/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.hud;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.content.entity.boss.ArmouredBoss;
import net.tslat.aoa3.library.object.RenderContext;
import net.tslat.aoa3.util.RegistryUtil;
import net.tslat.aoa3.util.RenderUtil;

public final class BossBarRenderer {
    public static final int STANDARD_BAR_WIDTH = 196;
    private static final Map<ResourceLocation, ResourceLocation> BAR_ID_CACHE = new Object2ObjectOpenHashMap();
    private static final ResourceLocation ARMOUR_OVERLAY = AdventOfAscension.id("textures/gui/bossbars/armour.png");

    public static void init() {
        NeoForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, CustomizeGuiOverlayEvent.BossEventProgress.class, BossBarRenderer::onBossInfoRender);
    }

    private static void onBossInfoRender(CustomizeGuiOverlayEvent.BossEventProgress ev) {
        if (ev.isCanceled() || Minecraft.getInstance().level == null) {
            return;
        }
        LerpingBossEvent bossStatusInfo = ev.getBossEvent();
        if (bossStatusInfo.getColor() != BossEvent.BossBarColor.GREEN || bossStatusInfo.getOverlay() != BossEvent.BossBarOverlay.NOTCHED_20) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Entity entity = (Entity)mc.level.getEntities().get(bossStatusInfo.getId());
        if (entity == null) {
            return;
        }
        ResourceLocation barTexture = BAR_ID_CACHE.computeIfAbsent(RegistryUtil.getId(entity.getType()), key -> ResourceLocation.fromNamespaceAndPath((String)key.getNamespace(), (String)("textures/gui/bossbars/" + key.getPath() + ".png")));
        RenderUtil.resetShaderColour();
        RenderUtil.prepRenderTexture(barTexture);
        Window window = mc.getWindow();
        PoseStack poseStack = ev.getGuiGraphics().pose();
        RenderContext renderContext = RenderContext.of(ev.getGuiGraphics());
        int xPos = window.getGuiScaledWidth() / 2 - 100;
        int yPos = ev.getY();
        float progressWidth = bossStatusInfo.getProgress() * 196.0f;
        Component displayName = bossStatusInfo.getName();
        if (progressWidth < 196.0f) {
            RenderUtil.renderCustomSizedTexture(poseStack, xPos, yPos, 0.0f, 12.0f, 200.0f, 12.0f, 200.0f, 36.0f);
        }
        if (progressWidth > 0.0f) {
            RenderUtil.renderCustomSizedTexture(poseStack, xPos + 2, yPos, 2.0f, 0.0f, progressWidth, 12.0f, 200.0f, 36.0f);
        }
        if (entity instanceof ArmouredBoss) {
            ArmouredBoss boss = (ArmouredBoss)entity;
            BossBarRenderer.renderArmourOverlay(poseStack, xPos, yPos, boss.getArmourPercent());
            RenderUtil.resetShaderColour();
            RenderUtil.prepRenderTexture(barTexture);
        }
        RenderUtil.renderCustomSizedTexture(poseStack, xPos, yPos, 0.0f, 24.0f, 200.0f, 12.0f, 200.0f, 36.0f);
        renderContext.renderText(displayName, window.getGuiScaledWidth() / 2 - mc.font.width((FormattedText)displayName) / 2, yPos - 9, 0xFFFFFF, RenderUtil.TextRenderType.DROP_SHADOW);
        ev.setIncrement(ev.getIncrement() + 5);
        ev.setCanceled(true);
    }

    private static void renderArmourOverlay(PoseStack poseStack, int xPos, int yPos, float armourPercent) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        RenderUtil.prepRenderTexture(ARMOUR_OVERLAY);
        RenderUtil.renderCustomSizedTexture(poseStack, xPos + 2, yPos, 2.0f, 0.0f, armourPercent * 196.0f, 12.0f, 200.0f, 12.0f);
    }
}

