/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.container;

import java.util.Collections;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.client.ClientHooks;
import net.tslat.aoa3.util.LocaleUtil;
import org.jetbrains.annotations.Nullable;

public class SelectInventoryItemScreen
extends ContainerScreen {
    @Nullable
    private final Item currentItem;
    private final Consumer<Item> selectionConsumer;

    public SelectInventoryItemScreen(Minecraft minecraft, @Nullable Item currentItem, Consumer<Item> selectionConsumer) {
        super(new ChestMenu(MenuType.GENERIC_9x1, 0, minecraft.player.getInventory(), (Container)new SimpleContainer(0), 0), minecraft.player.getInventory(), (Component)LocaleUtil.getLocaleMessage("gui.aoa3.selectItem.title"));
        this.currentItem = currentItem;
        this.selectionConsumer = selectionConsumer;
    }

    protected boolean checkHotbarKeyPressed(int pKeyCode, int pScanCode) {
        return false;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            ClientHooks.popGuiLayer((Minecraft)this.minecraft);
        }
        return true;
    }

    protected void slotClicked(Slot slot, int slotId, int button, ClickType clickType) {
        if (slot != null) {
            Item item = slot.getItem().getItem();
            if (this.currentItem == null && item != Items.AIR || this.currentItem != null && this.currentItem != item) {
                this.selectionConsumer.accept(item);
                ClientHooks.popGuiLayer((Minecraft)this.minecraft);
            }
        }
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        if (this.hoveredSlot != null) {
            MutableComponent component = null;
            if (this.hoveredSlot.hasItem()) {
                if (this.hoveredSlot.getItem().getItem() != this.currentItem) {
                    component = LocaleUtil.getLocaleMessage("gui.aoa3.selectItem.select", this.hoveredSlot.getItem().getHoverName());
                }
            } else if (this.currentItem != null) {
                component = LocaleUtil.getLocaleMessage("gui.aoa3.selectItem.remove");
            }
            if (component != null) {
                guiGraphics.renderComponentTooltip(this.font == null ? this.font : this.font, Collections.singletonList(component), x, y);
            }
        }
    }
}

