/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.container;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.common.menu.ImbuingChamberMenu;
import net.tslat.aoa3.content.item.misc.AspectFocusItem;
import net.tslat.aoa3.content.item.misc.PowerStone;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.EnchantmentUtil;
import net.tslat.aoa3.util.RenderUtil;

public class ImbuingChamberScreen
extends AbstractContainerScreen<ImbuingChamberMenu> {
    private static final ResourceLocation TEXTURES = AdventOfAscension.id("textures/gui/containers/imbuing_chamber.png");

    public ImbuingChamberScreen(ImbuingChamberMenu container, Inventory inv, Component guiTitle) {
        super((AbstractContainerMenu)container, inv, guiTitle);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0xB2B2B2, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY + 1, 0xB2B2B2, false);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        ImbuingChamberMenu menu = (ImbuingChamberMenu)this.getMenu();
        RenderUtil.prepRenderTexture(TEXTURES);
        RenderUtil.resetShaderColour();
        RenderUtil.renderCustomSizedTexture(guiGraphics.pose(), this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256.0f, 256.0f);
        int activationColour = this.renderBeam(guiGraphics, menu, partialTicks, mouseX, mouseY);
        RenderUtil.resetShaderColour();
        for (int i = 0; i < menu.inputSlotCount(); ++i) {
            Slot slot = menu.getSlot(i);
            RenderUtil.renderCustomSizedTexture(guiGraphics.pose(), this.leftPos + slot.x - 1, this.topPos + slot.y - 1, 26.0f, 166.0f, 18.0f, 18.0f, 256.0f, 256.0f);
        }
        if (activationColour >= 0) {
            RenderSystem.setShaderColor((float)((float)ColourUtil.getRed(activationColour) / 255.0f), (float)((float)ColourUtil.getGreen(activationColour) / 255.0f), (float)((float)ColourUtil.getBlue(activationColour) / 255.0f), (float)(ClientOperations.getPlayer().getRandom().nextFloat() * 0.2f + 0.8f));
            RenderUtil.renderCustomSizedTexture(guiGraphics.pose(), this.leftPos + 134, this.topPos + 30, 0.0f, 166.0f, 26.0f, 26.0f, 256.0f, 256.0f);
            RenderUtil.resetShaderColour();
            RenderUtil.renderCustomSizedTexture(guiGraphics.pose(), this.leftPos + 138, this.topPos + 34, 4.0f, 170.0f, 18.0f, 18.0f, 256.0f, 256.0f);
            ((ImbuingChamberMenu.ImbuingResultSlot)((ImbuingChamberMenu)this.getMenu()).getOutputSlot()).getCurrentRecipe().ifPresent(recipe -> {
                Component enchant = EnchantmentUtil.getFormattedName((Holder<Enchantment>)((Holder)recipe.getEnchant().left()), recipe.getEnchant().rightInt());
                RenderUtil.drawRectangle(guiGraphics.pose(), this.leftPos + 16, this.topPos + 59, Minecraft.getInstance().font.width((FormattedText)enchant) + 1, 10.0f, -872415232);
                RenderUtil.renderText(guiGraphics.pose(), enchant, this.leftPos + 17, this.topPos + 60, 0xB2B2B2, RenderUtil.TextRenderType.NORMAL);
            });
        } else {
            RenderUtil.renderCustomSizedTexture(guiGraphics.pose(), this.leftPos + 134, this.topPos + 30, 0.0f, 166.0f, 26.0f, 26.0f, 256.0f, 256.0f);
        }
    }

    private int renderBeam(GuiGraphics guiGraphics, ImbuingChamberMenu menu, float partialTicks, int mouseX, int mouseY) {
        NonNullList contents = menu.getItems();
        Item item = ((ItemStack)contents.get(0)).getItem();
        if (!(item instanceof PowerStone)) {
            return -1;
        }
        PowerStone powerStone = (PowerStone)item;
        int colour = powerStone.getColour();
        int currentIndex = 1;
        int lastIndex = 0;
        do {
            ItemStack slotStack;
            if ((slotStack = menu.getInputItem(currentIndex)).isEmpty() && currentIndex != 6) continue;
            int start = lastIndex * 18;
            float width = (currentIndex - lastIndex) * 18 - 2;
            RenderSystem.setShaderColor((float)((float)ColourUtil.getRed(colour) / 255.0f), (float)((float)ColourUtil.getGreen(colour) / 255.0f), (float)((float)ColourUtil.getBlue(colour) / 255.0f), (float)(ClientOperations.getPlayer().getRandom().nextFloat() * 0.4f + 0.6f));
            RenderUtil.renderCustomSizedTexture(guiGraphics.pose(), this.leftPos + 32 + start, this.topPos + 36, 44 + start, 166.0f, width, 14.0f, 256.0f, 256.0f);
            Item item2 = slotStack.getItem();
            if (item2 instanceof AspectFocusItem) {
                AspectFocusItem focus = (AspectFocusItem)item2;
                colour = ColourUtil.lerpColour(colour, focus.getFocus().colour(), 0.75f);
            }
            lastIndex = currentIndex;
        } while (++currentIndex < contents.size());
        return colour;
    }
}

