/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.container;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.menu.CorruptedTravellerMenu;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.library.object.RenderContext;
import net.tslat.aoa3.util.RenderUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4fStack;

public class CorruptedTravellerScreen
extends AbstractContainerScreen<CorruptedTravellerMenu> {
    private static final ResourceLocation GUI_TEXTURE = AdventOfAscension.id("textures/gui/containers/corrupted_traveller.png");
    private static final ArrayList<Item> APPLICABLE_FOOD = new ArrayList();
    private long nextFoodTick = 0L;
    private Item currentGhostlyFood = Items.APPLE;
    private final Minecraft mc = Minecraft.getInstance();

    public CorruptedTravellerScreen(CorruptedTravellerMenu container, Inventory inv, Component guiTitle) {
        super((AbstractContainerMenu)container, inv, guiTitle);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int centerX = (this.width - this.imageWidth) / 2;
        int centerY = (this.height - this.imageHeight) / 2;
        RenderContext renderContext = RenderContext.of(guiGraphics);
        renderContext.setTextureForRendering(GUI_TEXTURE);
        renderContext.resetShaderColour();
        renderContext.renderCustomSizedTexture(centerX, centerY, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256.0f, 256.0f);
        this.renderGhostlyFood(renderContext, centerX, centerY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        RenderContext renderContext = RenderContext.of(guiGraphics);
        int titleWidth = 4 + renderContext.textWidth((FormattedText)this.title);
        renderContext.setTextureForRendering(GUI_TEXTURE);
        renderContext.renderCustomSizedTexture(28, 4, 176.0f, 0.0f, 1.0f, 12.0f, 256.0f, 256.0f);
        for (int i = 0; i < titleWidth - 2; ++i) {
            renderContext.renderCustomSizedTexture(29 + i, 4, 177.0f, 0.0f, 1.0f, 12.0f, 256.0f, 256.0f);
        }
        renderContext.renderCustomSizedTexture(28 + titleWidth - 2, 4, 178.0f, 0.0f, 1.0f, 12.0f, 256.0f, 256.0f);
        renderContext.resetShaderColour();
        renderContext.renderText(this.title, 30.0f, 6.0f, 0xFFFFFF, RenderUtil.TextRenderType.NORMAL);
    }

    private void renderGhostlyFood(RenderContext renderContext, int centerX, int centerY) {
        Slot slot = ((CorruptedTravellerMenu)this.menu).getSlot(0);
        if (!slot.hasItem()) {
            boolean changeLighting;
            ItemStack stack = new ItemStack((ItemLike)this.getGhostlyFood());
            ItemRenderer itemRenderer = this.mc.getItemRenderer();
            BakedModel model = itemRenderer.getModel(stack, null, null, 0);
            this.mc.getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS).setFilter(false, false);
            RenderUtil.setRenderingTexture(TextureAtlas.LOCATION_BLOCKS);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderUtil.resetShaderColour();
            Matrix4fStack modelViewPose = RenderSystem.getModelViewStack();
            modelViewPose.pushMatrix();
            modelViewPose.translate((float)(slot.x + centerX), (float)(slot.y + centerY), 100.0f);
            modelViewPose.translate(8.0f, 8.0f, 0.0f);
            modelViewPose.scale(1.0f, -1.0f, 1.0f);
            modelViewPose.scale(16.0f, 16.0f, 16.0f);
            RenderSystem.applyModelViewMatrix();
            PoseStack poseStack = new PoseStack();
            MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
            boolean bl = changeLighting = !model.usesBlockLight();
            if (changeLighting) {
                Lighting.setupForFlatItems();
            }
            itemRenderer.render(stack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)bufferSource, 40, OverlayTexture.NO_OVERLAY, model);
            bufferSource.endBatch();
            RenderSystem.enableDepthTest();
            if (changeLighting) {
                Lighting.setupFor3DItems();
            }
            modelViewPose.popMatrix();
            RenderSystem.applyModelViewMatrix();
        }
    }

    private void compileFoodList() {
        AoARegistries.ITEMS.getAllRegisteredObjects().filter(item -> item.components().has(DataComponents.FOOD)).forEach(APPLICABLE_FOOD::add);
    }

    @NotNull
    private Item getGhostlyFood() {
        long worldTick;
        if (APPLICABLE_FOOD.isEmpty()) {
            this.compileFoodList();
        }
        if ((worldTick = this.mc.level.getGameTime()) >= this.nextFoodTick) {
            this.currentGhostlyFood = APPLICABLE_FOOD.get(RandomUtil.randomNumberUpTo((int)APPLICABLE_FOOD.size()));
            this.nextFoodTick = worldTick + 20L;
        }
        return this.currentGhostlyFood;
    }
}

