/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.adventgui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.AoAKeybinds;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabBestiary;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabHelp;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabLeaderboard;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabLore;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabPlayer;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.data.client.AdventGuiThemeReloadListener;
import net.tslat.aoa3.integration.IntegrationManager;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.HolidayUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RenderUtil;
import net.tslat.aoa3.util.StringUtil;
import net.tslat.aoa3.util.WebUtil;
import org.jetbrains.annotations.Nullable;

public class AdventMainGui
extends Screen {
    private static final ResourceLocation TITLE = HolidayUtil.isAprilFools() ? AdventOfAscension.id("textures/gui/adventgui/aoa_title_alt.png") : AdventOfAscension.id("textures/gui/adventgui/aoa_title.png");
    protected static final int GUI_WIDTH = 1024;
    protected static final int GUI_HEIGHT = 512;
    protected static final int BACKGROUND_TEXTURE_WIDTH = 976;
    protected static final int BACKGROUND_TEXTURE_HEIGHT = 480;
    protected static float SCALE = 0.45f;
    protected static AdventMainGui instance;
    protected static AdventGuiThemeReloadListener.AdventGuiTheme theme;
    private static ADVENT_WINDOW_TAB selectedTab;
    @Nullable
    private static Screen tabScreen;
    protected Player player;
    protected static int scaledRootX;
    protected static int scaledRootY;
    protected static int scaledTabRootX;
    protected static int scaledTabRootY;
    private static int updateMessageTicker;

    public AdventMainGui(Player player) {
        super((Component)Component.translatable((String)"gui.aoa3.adventGui.title"));
        this.player = player;
        instance = this;
        tabScreen = null;
    }

    protected void init() {
        theme = AdventGuiThemeReloadListener.setTheme((String)AoAConfigs.CLIENT.adventGuiTheme.get());
        this.addRenderableWidget((GuiEventListener)new AdventMainGuiTabButton(11, 129, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.stats"), ADVENT_WINDOW_TAB.PLAYER));
        this.addRenderableWidget((GuiEventListener)new AdventMainGuiTabButton(11, 199, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.bestiary"), ADVENT_WINDOW_TAB.BESTIARY));
        this.addRenderableWidget((GuiEventListener)new AdventMainGuiTabButton(11, 269, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.lore"), ADVENT_WINDOW_TAB.LORE));
        this.addRenderableWidget((GuiEventListener)new AdventMainGuiTabButton(11, 339, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.leaderboards"), ADVENT_WINDOW_TAB.LEADERBOARDS));
        this.addRenderableWidget((GuiEventListener)new AdventMainGuiTabButton(11, 409, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.help"), ADVENT_WINDOW_TAB.HELP));
        this.correctGuiPositions();
        this.initTabScreen();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.scale(SCALE, SCALE, SCALE);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)theme.backgroundTexture());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.renderCustomSizedTexture(poseStack, scaledRootX, scaledRootY, 24.0f, 16.0f, 976.0f, 480.0f, 1024.0f, 512.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TITLE);
        RenderUtil.renderCustomSizedTexture(poseStack, scaledRootX - 24 + 68, scaledRootY - 16 + 21, 0.0f, 0.0f, 892.0f, 112.0f, 892.0f, 112.0f);
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (theme.overlayTexture() != null) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)theme.overlayTexture());
            RenderSystem.enableBlend();
            RenderUtil.renderCustomSizedTexture(poseStack, scaledRootX - 24, scaledRootY - 16, 0.0f, 0.0f, 1024.0f, 512.0f, 1024.0f, 512.0f);
            RenderSystem.disableBlend();
        }
        if (HolidayUtil.isAnniversary()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)AdventOfAscension.id("textures/gui/adventgui/birthday.png"));
            RenderSystem.enableBlend();
            RenderUtil.renderCustomSizedTexture(poseStack, scaledRootX - 24 + 68, scaledRootY - 16 + 21, 0.0f, 0.0f, 42.0f, 42.0f, 42.0f, 42.0f);
            RenderSystem.disableBlend();
        }
        RenderUtil.renderScaledText(poseStack, (Component)Component.literal((String)("v" + AdventOfAscension.getVersion() + " (" + SharedConstants.getCurrentVersion().getName() + ")")), scaledRootX + 175, scaledRootY + 85, 1.25f, ColourUtil.RGB(255, 223, 0), RenderUtil.TextRenderType.DROP_SHADOW);
        if (WebUtil.isUpdateAvailable()) {
            if (--updateMessageTicker <= -30) {
                updateMessageTicker = 90;
            }
            if (updateMessageTicker > 0) {
                MutableComponent msg = LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.update", new Component[]{Component.literal((String)WebUtil.getLatestVersion())});
                RenderUtil.renderScaledText(poseStack, (Component)msg, scaledRootX + 915 - this.font.width((FormattedText)msg), scaledRootY + 105, 1.25f, ColourUtil.RGB(229, 0, 0), RenderUtil.TextRenderType.DROP_SHADOW);
            }
        }
        if (tabScreen != null) {
            tabScreen.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    public static boolean isBlockingKeys() {
        if (tabScreen instanceof AdventGuiTabBestiary) {
            EditBox bestiarySearchField = ((AdventGuiTabBestiary)AdventMainGui.tabScreen).searchField;
            return bestiarySearchField != null && bestiarySearchField.isFocused();
        }
        return false;
    }

    public void onStatsUpdated() {
        Screen screen = tabScreen;
        if (screen instanceof AdventGuiTabBestiary) {
            AdventGuiTabBestiary bestiary = (AdventGuiTabBestiary)screen;
            bestiary.onStatsUpdated();
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double lateralScroll, double verticalScroll) {
        if (tabScreen != null) {
            return tabScreen.mouseScrolled(mouseX, mouseY, lateralScroll, verticalScroll);
        }
        return super.mouseScrolled(mouseX, mouseY, lateralScroll, verticalScroll);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (tabScreen != null && tabScreen.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (tabScreen != null && tabScreen.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (tabScreen != null && tabScreen.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!AdventMainGui.isBlockingKeys() && keyCode == AoAKeybinds.ADVENT_GUI.getKey().getValue()) {
            this.getMinecraft().setScreen(null);
            return true;
        }
        boolean used = false;
        if (tabScreen != null) {
            used = tabScreen.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers) || used;
    }

    public boolean charTyped(char character, int arg) {
        if (tabScreen != null) {
            return tabScreen.charTyped(character, arg);
        }
        return super.charTyped(character, arg);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (!super.keyReleased(keyCode, scanCode, modifiers)) {
            if (tabScreen != null) {
                return tabScreen.keyReleased(keyCode, scanCode, modifiers);
            }
            return false;
        }
        return true;
    }

    private void initTabScreen() {
        Minecraft mc = this.getMinecraft();
        int tabWidth = (int)((float)(this.width + 182) * SCALE);
        int tabHeight = (int)((float)(this.height + 118) * SCALE);
        if (tabScreen != null) {
            tabScreen.init(mc, tabWidth, tabHeight);
        } else {
            switch (selectedTab.ordinal()) {
                case 0: {
                    tabScreen = new AdventGuiTabPlayer();
                    break;
                }
                case 4: {
                    tabScreen = new AdventGuiTabHelp();
                    break;
                }
                case 1: {
                    tabScreen = new AdventGuiTabBestiary();
                    break;
                }
                case 2: {
                    tabScreen = new AdventGuiTabLore();
                    break;
                }
                case 3: {
                    tabScreen = new AdventGuiTabLeaderboard();
                    break;
                }
            }
            if (tabScreen != null) {
                tabScreen.init(mc, tabWidth, tabHeight);
                tabScreen.resize(mc, tabWidth, tabHeight);
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void correctGuiPositions() {
        Window window = this.getMinecraft().getWindow();
        float scaleDeltaRatio = (float)window.calculateScale(0, this.getMinecraft().isEnforceUnicode()) / (float)window.getGuiScale();
        SCALE = 0.45f * scaleDeltaRatio;
        scaledRootX = (int)(Math.round((double)window.getGuiScaledWidth() / 2.0 / (double)SCALE) - Math.round(488.0));
        scaledRootY = (int)(Math.round((double)window.getGuiScaledHeight() / 2.0 / (double)SCALE) - Math.round(240.0));
        scaledTabRootX = scaledRootX + 201;
        scaledTabRootY = scaledRootY + 129;
    }

    public void resize(Minecraft mc, int width, int height) {
        super.resize(mc, width, height);
        this.correctGuiPositions();
        if (tabScreen != null) {
            tabScreen.resize(mc, (int)((float)(width + 182) * SCALE), (int)((float)(height + 118) * SCALE));
        }
    }

    public void removed() {
        super.removed();
        if (tabScreen != null) {
            tabScreen.removed();
        }
    }

    public static void changeTheme() {
        theme = AdventGuiThemeReloadListener.getNextTheme();
        AoAConfigs.CLIENT.changeAdventGuiTheme(StringUtil.toTitleCase(theme.id()));
    }

    static {
        theme = null;
        selectedTab = ADVENT_WINDOW_TAB.PLAYER;
        updateMessageTicker = 0;
    }

    private static class AdventMainGuiTabButton
    extends Button {
        private static final int buttonWidth = 180;
        private static final int buttonHeight = 60;
        private final ADVENT_WINDOW_TAB tabID;

        private AdventMainGuiTabButton(int x, int y, Component buttonText, ADVENT_WINDOW_TAB tab) {
            super(x, y, 180, 60, buttonText, button -> {}, DEFAULT_NARRATION);
            this.tabID = tab;
            if (tab == ADVENT_WINDOW_TAB.LORE && !IntegrationManager.isPatchouliActive()) {
                this.active = false;
            }
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.visible) {
                Minecraft mc = Minecraft.getInstance();
                PoseStack poseStack = guiGraphics.pose();
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)theme.menuButtonTexture());
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.isHovered = this.isMouseInRegion(mouseX, mouseY, this.getX(), this.getY());
                boolean textureX = false;
                int textureY = 60 * (this.tabID == selectedTab ? 0 : RenderUtil.selectVForWidgetState((AbstractWidget)this, 2, 2, 1));
                RenderUtil.renderScaledCustomSizedTexture(poseStack, scaledRootX + this.getX(), scaledRootY + this.getY(), (float)textureX, textureY, 180.0f, 60.0f, 180.0f, 60.0f, 180.0f, 180.0f);
                int stringColour = 0xE0E0E0;
                if (this.getFGColor() >= 0) {
                    stringColour = this.getFGColor();
                }
                if (this.isHovered() && this.tabID != selectedTab) {
                    stringColour = 0xFFFFA0;
                }
                RenderUtil.renderCenteredScaledText(poseStack, this.getMessage(), scaledRootX + this.getX() + 90, scaledRootY + this.getY() + 25, 2.0f, stringColour, RenderUtil.TextRenderType.OUTLINED);
                poseStack.pushPose();
                poseStack.scale(2.0f, 2.0f, 2.0f);
                if (this.isHovered) {
                    if (!this.active && this.tabID == ADVENT_WINDOW_TAB.LORE) {
                        this.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.aoa3.adventGui.lore.patchouli")));
                    } else {
                        this.setTooltip(null);
                    }
                }
                poseStack.popPose();
            }
        }

        protected boolean clicked(double mouseX, double mouseY) {
            return this.active && this.isHovered && selectedTab != this.tabID;
        }

        public void onClick(double mouseX, double mouseY) {
            selectedTab = this.tabID;
            tabScreen = null;
            instance.initTabScreen();
        }

        private boolean isMouseInRegion(int mouseX, int mouseY, int buttonX, int buttonY) {
            return mouseX >= (int)((float)(scaledRootX + buttonX) * SCALE) && mouseX <= (int)((float)(scaledRootX + buttonX + 180) * SCALE) && mouseY >= (int)((float)(scaledRootY + buttonY) * SCALE) && mouseY <= (int)((float)(scaledRootY + buttonY + 60) * SCALE);
        }
    }

    protected static enum ADVENT_WINDOW_TAB {
        PLAYER,
        BESTIARY,
        LORE,
        LEADERBOARDS,
        HELP;

    }
}

