/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.adventgui;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.tslat.aoa3.client.gui.adventgui.AdventMainGui;
import net.tslat.aoa3.client.gui.lib.ScrollablePane;
import net.tslat.aoa3.client.player.ClientPlayerDataManager;
import net.tslat.aoa3.library.object.RenderContext;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RenderUtil;
import org.jetbrains.annotations.Nullable;

public class AdventGuiTabLeaderboard
extends Screen {
    private CategoryMenu categoryMenu;
    @Nullable
    private AoASkill currentSkill = null;
    private volatile PageData currentData = null;
    private int adjustedMouseX;
    private int adjustedMouseY;

    protected AdventGuiTabLeaderboard() {
        super((Component)Component.translatable((String)"gui.aoa3.adventGui.leaderboards"));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.adjustedMouseX = (int)((float)mouseX * (1.0f / AdventMainGui.SCALE));
        this.adjustedMouseY = (int)((float)mouseY * (1.0f / AdventMainGui.SCALE));
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, this.adjustedMouseX, this.adjustedMouseY, partialTick);
        }
        this.categoryMenu.render(guiGraphics, this.adjustedMouseX, this.adjustedMouseY, partialTick);
        RenderContext renderContext = RenderContext.of(guiGraphics);
        int boardPaneLeft = AdventMainGui.scaledTabRootX + 136;
        int boardPaneWidth = 629;
        renderContext.renderCenteredScaledText((Component)(this.currentSkill == null ? LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.player.totalLevel") : this.currentSkill.getName()), (float)boardPaneLeft + 314.5f, AdventMainGui.scaledTabRootY + 10, 1.5f, 0xE0E0E0, RenderUtil.TextRenderType.DROP_SHADOW);
        renderContext.renderCenteredScaledText((Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.leaderboards.rank"), boardPaneLeft + 50, AdventMainGui.scaledTabRootY + 50, 1.5f, 0xE0E0E0, RenderUtil.TextRenderType.DROP_SHADOW);
        renderContext.renderCenteredScaledText((Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.leaderboards.player"), (float)boardPaneLeft + 251.6f, AdventMainGui.scaledTabRootY + 50, 1.5f, 0xE0E0E0, RenderUtil.TextRenderType.DROP_SHADOW);
        renderContext.renderCenteredScaledText((Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.player.skillLevel"), boardPaneLeft + 525, AdventMainGui.scaledTabRootY + 50, 1.5f, 0xE0E0E0, RenderUtil.TextRenderType.DROP_SHADOW);
        PageData currentData = this.currentData;
        if (currentData == null) {
            currentData = new PageData(1, new Component[]{Minecraft.getInstance().player.getDisplayName()}, new int[]{this.currentSkill == null ? ClientPlayerDataManager.get().getTotalLevel() : ClientPlayerDataManager.get().getSkill(this.currentSkill).getLevel(true)});
        }
        int pageNum = currentData.page();
        for (int i = 1; i <= 10; ++i) {
            int y = AdventMainGui.scaledTabRootY + 71 + 27 * (i - 1);
            guiGraphics.fill(boardPaneLeft, y, boardPaneLeft + 629, y + 27, i % 2 == 0 ? -1072689136 : -804253680);
            if (i - 1 >= currentData.players.length) continue;
            renderContext.renderCenteredScaledText((Component)Component.literal((String)String.valueOf((pageNum - 1) * 10 + i)), boardPaneLeft + 50, y + 8, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.DROP_SHADOW);
            renderContext.renderScaledText(currentData.players[i - 1], boardPaneLeft + 150, y + 8, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.DROP_SHADOW);
            renderContext.renderCenteredScaledText((Component)Component.literal((String)String.valueOf(currentData.levels[i - 1])), boardPaneLeft + 525, y + 8, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.DROP_SHADOW);
        }
    }

    public void renderTransparentBackground(GuiGraphics pGuiGraphics) {
    }

    protected void init() {
        if (this.categoryMenu == null) {
            this.categoryMenu = new CategoryMenu(this.getMinecraft(), AdventMainGui.scaledTabRootY, AdventMainGui.scaledTabRootX, 340, 125, AdventMainGui.SCALE);
        }
    }

    public void resize(Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        if (this.categoryMenu != null) {
            this.categoryMenu.onResize(this.getMinecraft(), AdventMainGui.scaledTabRootX, AdventMainGui.scaledTabRootY, 135, 340);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double lateralScroll, double verticalScroll) {
        if (this.categoryMenu != null) {
            return this.categoryMenu.handleMouseScroll(-1.0, -1.0, verticalScroll);
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.categoryMenu != null && this.categoryMenu.handleMouseClick(this.adjustedMouseX, this.adjustedMouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.categoryMenu != null) {
            return this.categoryMenu.handleMouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    public record PageData(int page, Component[] players, int[] levels) {
    }

    private class CategoryMenu
    extends ScrollablePane {
        private final List<SkillSelectButton> buttons;

        public CategoryMenu(Minecraft mc, int top, int left, int viewHeight, int viewWidth, float renderingScale) {
            super(mc, top, left, viewHeight, viewWidth, renderingScale);
            this.buttons = new ObjectArrayList();
            this.buttons.add(new SkillSelectButton(35, 35, null));
            for (AoASkill.Instance skill : ClientPlayerDataManager.get().getSkills()) {
                this.buttons.add(new SkillSelectButton(35, 35, skill.type()));
            }
        }

        @Override
        public int getFullPaneHeight() {
            return 10 + this.buttons.size() * 45;
        }

        @Override
        public void drawPaneContents(GuiGraphics guiGraphics, int top, int left, int right, int bottom, float scrollDistance, float partialTicks) {
            int y = 10;
            for (SkillSelectButton button : this.buttons) {
                button.x = left + 10;
                button.y = top + y;
                button.render(guiGraphics, (int)this.mouseX, (int)this.mouseY, partialTicks);
                y += 45;
            }
        }

        @Override
        public void drawBackground(GuiGraphics guiGraphics) {
        }

        @Override
        public boolean handleMouseClick(double mouseX, double mouseY, int button) {
            super.handleMouseClick(mouseX, mouseY, button);
            boolean clicked = false;
            for (SkillSelectButton skillButton : this.buttons) {
                if (!skillButton.isMouseOver) continue;
                AdventGuiTabLeaderboard.this.currentSkill = skillButton.skill;
                clicked = true;
            }
            return clicked;
        }

        private class SkillSelectButton {
            protected final int height;
            protected int width;
            @Nullable
            protected AoASkill skill;
            protected Component text;
            protected boolean isMouseOver = false;
            protected float x;
            protected float y;

            public SkillSelectButton(int minWidth, @Nullable int height, AoASkill skill) {
                this.width = minWidth;
                this.height = height;
                this.skill = skill;
                MutableComponent mutableComponent = this.text = this.skill == null ? LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.player.totalLevel") : skill.getName();
                if (skill == null) {
                    AdventGuiTabLeaderboard.this.currentSkill = this.skill;
                }
            }

            public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                this.isMouseOver = this.isMouseOver(mouseX, mouseY);
                this.width = (int)(10.0f + (float)Minecraft.getInstance().font.width((FormattedText)this.text) * 1.5f);
                RenderContext renderContext = RenderContext.of(guiGraphics);
                renderContext.setTextureForRendering(AdventMainGui.theme.menuButtonTexture());
                renderContext.renderScaledCustomSizedTexture(this.x, this.y, 0.0f, AdventGuiTabLeaderboard.this.currentSkill == this.skill ? 0.0f : (this.isMouseOver ? 60.0f : 120.0f), 180.0f, 60.0f, this.width, this.height, 180.0f, 180.0f);
                int stringColour = 0xE0E0E0;
                if (this.isMouseOver && AdventGuiTabLeaderboard.this.currentSkill != this.skill) {
                    stringColour = 0xFFFFA0;
                }
                renderContext.renderCenteredScaledText(this.text, (int)(this.x + (float)this.width / 2.0f), (int)((double)this.y + (double)this.height / 2.5), 1.5f, stringColour, RenderUtil.TextRenderType.DROP_SHADOW);
            }

            private boolean isMouseOver(int mouseX, int mouseY) {
                return (float)mouseX >= this.x && (float)mouseX <= this.x + (float)this.width && (float)mouseY >= this.y && (float)mouseY <= this.y + (float)this.height;
            }
        }
    }
}

