/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client;

import java.util.function.Function;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.model.DynamicFluidContainerModel;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.block.AoABlocks;

public final class AoATintHandling {
    public static void init() {
        IEventBus modBus = AdventOfAscension.getModEventBus();
        modBus.addListener(AoATintHandling::registerBlockColours);
        modBus.addListener(AoATintHandling::registerItemColours);
    }

    private static void registerBlockColours(RegisterColorHandlersEvent.Block ev) {
        BlockColors blockColors = ev.getBlockColors();
        Function<BlockState, BlockColor> vanillaColouring = referenceBlock -> (state, level, pos, tintIndex) -> blockColors.getColor(referenceBlock, level, pos, tintIndex);
        ev.register(vanillaColouring.apply(Blocks.GRASS_BLOCK.defaultBlockState()), new Block[]{(Block)AoABlocks.PRECASIAN_GRASS.get(), (Block)AoABlocks.CALAB_GRASS.get(), (Block)AoABlocks.CALAB_LONG_GRASS.get()});
        ev.register(vanillaColouring.apply(Blocks.ACACIA_LEAVES.defaultBlockState()), new Block[]{(Block)AoABlocks.BAOBAB_LEAVES.get(), (Block)AoABlocks.LUCALUS_LEAVES.get(), (Block)AoABlocks.STRANGLEWOOD_LEAVES.get(), (Block)AoABlocks.STRANGLEWOOD_LOG.get(), (Block)AoABlocks.STRANGLEWOOD.get()});
        ev.register((state, level, pos, tintIndex) -> {
            if (level == null || pos == null) {
                return FoliageColor.getEvergreenColor();
            }
            float desaturation = (float)level.getRawBrightness(pos, 0) * 0.04f;
            return FoliageColor.get((double)(0.1f + desaturation), (double)(1.3f - desaturation * 2.0f));
        }, new Block[]{(Block)AoABlocks.ANCIENT_VINES.get()});
    }

    private static void registerItemColours(RegisterColorHandlersEvent.Item ev) {
        ItemColors itemColors = ev.getItemColors();
        Function<ItemStack, ItemColor> vanillaColouring = referenceStack -> (stack, tintIndex) -> itemColors.getColor(referenceStack, tintIndex);
        ev.register(vanillaColouring.apply(Items.GRASS_BLOCK.getDefaultInstance()), new ItemLike[]{(ItemLike)AoABlocks.PRECASIAN_GRASS.get(), (ItemLike)AoABlocks.CALAB_GRASS.get(), (ItemLike)AoABlocks.CALAB_LONG_GRASS.get()});
        ev.register(vanillaColouring.apply(Items.ACACIA_LEAVES.getDefaultInstance()), new ItemLike[]{(ItemLike)AoABlocks.BAOBAB_LEAVES.get(), (ItemLike)AoABlocks.LUCALUS_LEAVES.get(), (ItemLike)AoABlocks.STRANGLEWOOD_LEAVES.get(), (ItemLike)AoABlocks.STRANGLEWOOD_LOG.get(), (ItemLike)AoABlocks.STRANGLEWOOD.get()});
        ev.register((ItemColor)new DynamicFluidContainerModel.Colors(), new ItemLike[]{AoABlocks.CANDIED_WATER.getBucket()});
        ev.register((ItemColor)new DynamicFluidContainerModel.Colors(), new ItemLike[]{AoABlocks.TOXIC_WASTE.getBucket()});
        ev.register((ItemColor)new DynamicFluidContainerModel.Colors(), new ItemLike[]{AoABlocks.TAR.getBucket()});
    }
}

