/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client;

import java.util.function.Consumer;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.AoAEntityRendering;
import net.tslat.aoa3.client.AoAKeybinds;
import net.tslat.aoa3.client.AoATintHandling;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.client.clientextension.fluid.CandiedWaterClientExtension;
import net.tslat.aoa3.client.clientextension.fluid.TarClientExtension;
import net.tslat.aoa3.client.clientextension.fluid.ToxicWasteClientExtension;
import net.tslat.aoa3.client.clientextension.item.AttuningBowlClientExtension;
import net.tslat.aoa3.client.clientextension.item.LargeGunClientExtension;
import net.tslat.aoa3.client.clientextension.item.SkillHelmetClientExtension;
import net.tslat.aoa3.client.clientextension.item.SmallGunClientExtension;
import net.tslat.aoa3.client.event.ClientEventHandler;
import net.tslat.aoa3.client.gui.container.BankerScreen;
import net.tslat.aoa3.client.gui.container.CorruptedTravellerScreen;
import net.tslat.aoa3.client.gui.container.DivineStationScreen;
import net.tslat.aoa3.client.gui.container.FrameBenchScreen;
import net.tslat.aoa3.client.gui.container.Generic2SlotContainerScreen;
import net.tslat.aoa3.client.gui.container.ImbuingChamberScreen;
import net.tslat.aoa3.client.gui.container.InfusedPressScreen;
import net.tslat.aoa3.client.gui.container.InfusionTableScreen;
import net.tslat.aoa3.client.gui.container.TinkerersTableScreen;
import net.tslat.aoa3.client.gui.hud.AoACameraModifications;
import net.tslat.aoa3.client.gui.hud.BossBarRenderer;
import net.tslat.aoa3.client.gui.hud.HealthStatusRenderer;
import net.tslat.aoa3.client.gui.hud.XpParticlesRenderer;
import net.tslat.aoa3.client.gui.overlay.ScopeOverlayRenderer;
import net.tslat.aoa3.client.gui.overlay.ScreenEffectRenderer;
import net.tslat.aoa3.client.model.ModelProperties;
import net.tslat.aoa3.client.particle.EntityOrbitingParticle;
import net.tslat.aoa3.client.particle.FloatingItemFragmentParticle;
import net.tslat.aoa3.client.particle.GenericSpriteParticle;
import net.tslat.aoa3.client.particle.OrbParticle;
import net.tslat.aoa3.client.particle.entityaffecting.BurningFlameParticle;
import net.tslat.aoa3.client.particle.entityaffecting.EntityAffectingParticle;
import net.tslat.aoa3.client.particle.entityaffecting.FreezingSnowflakeParticle;
import net.tslat.aoa3.client.particle.entityaffecting.SandstormParticle;
import net.tslat.aoa3.client.render.AoAGuiElementRenderers;
import net.tslat.aoa3.client.render.dimension.AoADimensionRenderEffects;
import net.tslat.aoa3.client.render.entity.misc.OccultBlockRenderer;
import net.tslat.aoa3.client.render.shader.AoAPostProcessing;
import net.tslat.aoa3.common.registration.AoAMenus;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.block.AoAFluidTypes;
import net.tslat.aoa3.common.registration.item.AoAArmour;
import net.tslat.aoa3.common.registration.item.AoATools;
import net.tslat.aoa3.content.item.weapon.cannon.BaseCannon;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.content.item.weapon.sniper.BaseSniper;
import net.tslat.aoa3.content.item.weapon.thrown.BaseThrownWeapon;
import net.tslat.aoa3.data.client.AoAResourceReloadListeners;
import net.tslat.aoa3.integration.IntegrationManager;

public final class AoAClientSetup {
    public static void init(ModContainer modContainer) {
        AoAEntityRendering.init();
        ClientEventHandler.init();
        AoAPostProcessing.init();
        AoAGuiElementRenderers.init();
        AoAKeybinds.init();
        AoAResourceReloadListeners.init();
        ScopeOverlayRenderer.init();
        XpParticlesRenderer.init();
        ScreenEffectRenderer.init();
        AoADimensionRenderEffects.init();
        AoATintHandling.init();
        BossBarRenderer.init();
        AoACameraModifications.init();
        HealthStatusRenderer.init();
        OccultBlockRenderer.init();
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        AdventOfAscension.getModEventBus().addListener(EventPriority.NORMAL, false, RegisterParticleProvidersEvent.class, AoAClientSetup::registerParticleFactories);
        AdventOfAscension.getModEventBus().addListener(EventPriority.NORMAL, false, RegisterMenuScreensEvent.class, AoAClientSetup::registerMenuScreens);
        AdventOfAscension.getModEventBus().addListener(EventPriority.NORMAL, false, RegisterClientExtensionsEvent.class, AoAClientSetup::registerClientExtensions);
    }

    public static void postInit(Consumer<Runnable> workQueue) {
        workQueue.accept(() -> {
            AoABlocks.getRegisteredLiquidsForRenderTypes().forEach(ClientOperations::applyFluidRenderType);
            ModelProperties.init();
            AoAGuiElementRenderers.lateInit();
            IntegrationManager.clientInit();
        });
    }

    private static void registerMenuScreens(RegisterMenuScreensEvent ev) {
        ev.register((MenuType)AoAMenus.DIVINE_STATION.get(), DivineStationScreen::new);
        ev.register((MenuType)AoAMenus.MENDING_TABLE.get(), Generic2SlotContainerScreen::new);
        ev.register((MenuType)AoAMenus.WHITEWASHING_TABLE.get(), Generic2SlotContainerScreen::new);
        ev.register((MenuType)AoAMenus.FRAME_BENCH.get(), FrameBenchScreen::new);
        ev.register((MenuType)AoAMenus.INFUSION_TABLE.get(), InfusionTableScreen::new);
        ev.register((MenuType)AoAMenus.INFUSED_PRESS.get(), InfusedPressScreen::new);
        ev.register((MenuType)AoAMenus.TINKERERS_TABLE.get(), TinkerersTableScreen::new);
        ev.register((MenuType)AoAMenus.IMBUING_CHAMBER.get(), ImbuingChamberScreen::new);
        ev.register((MenuType)AoAMenus.TRADER.get(), MerchantScreen::new);
        ev.register((MenuType)AoAMenus.BANKER.get(), BankerScreen::new);
        ev.register((MenuType)AoAMenus.CORRUPTED_TRAVELLER.get(), CorruptedTravellerScreen::new);
    }

    private static void registerParticleFactories(RegisterParticleProvidersEvent ev) {
        ev.registerSpriteSet((ParticleType)AoAParticleTypes.GENERIC_DUST.get(), GenericSpriteParticle.Provider::new);
        ev.registerSpecial((ParticleType)AoAParticleTypes.FLOATING_ITEM_FRAGMENT.get(), (ParticleProvider)new FloatingItemFragmentParticle.Factory());
        ev.registerSprite((ParticleType)AoAParticleTypes.FREEZING_SNOWFLAKE.get(), new EntityAffectingParticle.SingleSpriteProvider<FreezingSnowflakeParticle>(FreezingSnowflakeParticle::new));
        ev.registerSpriteSet((ParticleType)AoAParticleTypes.BURNING_FLAME.get(), sprites -> new EntityAffectingParticle.Provider<BurningFlameParticle>(sprites, BurningFlameParticle::new));
        ev.registerSpriteSet((ParticleType)AoAParticleTypes.SANDSTORM.get(), sprites -> new EntityAffectingParticle.Provider<SandstormParticle>(sprites, SandstormParticle::new));
        ev.registerSprite((ParticleType)AoAParticleTypes.ORB.get(), (ParticleProvider.Sprite)new OrbParticle.Provider());
        ev.registerSpriteSet((ParticleType)AoAParticleTypes.FIRE_AURA.get(), EntityOrbitingParticle.Provider::new);
    }

    private static void registerClientExtensions(RegisterClientExtensionsEvent ev) {
        ev.registerItem((IClientItemExtensions)new SkillHelmetClientExtension(), new Item[]{(Item)AoAArmour.HELM_OF_THE_DEXTROUS.get(), (Item)AoAArmour.HELM_OF_THE_DRYAD.get(), (Item)AoAArmour.HELM_OF_THE_RITUALIST.get(), (Item)AoAArmour.HELM_OF_THE_TRAWLER.get(), (Item)AoAArmour.HELM_OF_THE_TREASURER.get(), (Item)AoAArmour.HELM_OF_THE_WARRIOR.get()});
        ev.registerItem((IClientItemExtensions)new AttuningBowlClientExtension(), new Item[]{(Item)AoATools.ATTUNING_BOWL.get()});
        for (DeferredHolder<Item, Item> item : AoARegistries.ITEMS.getAllAoARegisteredObjects()) {
            BaseGun gun;
            Object object = item.get();
            if (!(object instanceof BaseGun) || (gun = (BaseGun)((Object)object)) instanceof BaseThrownWeapon) continue;
            if (gun instanceof BaseCannon || gun instanceof BaseSniper) {
                ev.registerItem((IClientItemExtensions)new LargeGunClientExtension(), new Holder[]{item});
                continue;
            }
            ev.registerItem((IClientItemExtensions)new SmallGunClientExtension(), new Holder[]{item});
        }
        ev.registerFluidType((IClientFluidTypeExtensions)new ToxicWasteClientExtension(), new FluidType[]{(FluidType)AoAFluidTypes.TOXIC_WASTE.get()});
        ev.registerFluidType((IClientFluidTypeExtensions)new TarClientExtension(), new FluidType[]{(FluidType)AoAFluidTypes.TAR.get()});
        ev.registerFluidType((IClientFluidTypeExtensions)new CandiedWaterClientExtension(), new FluidType[]{(FluidType)AoAFluidTypes.CANDIED_WATER.get()});
    }
}

