/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.neoforged.fml.common.asm.enumextension.EnumProxy;
import net.tslat.aoa3.common.registration.item.AoAEnchantments;
import net.tslat.aoa3.common.registration.item.AoATools;
import net.tslat.aoa3.util.EnchantmentUtil;

public final class AoAArmPoses {
    public static final EnumProxy<HumanoidModel.ArmPose> ATTUNING_BOWL = new EnumProxy(HumanoidModel.ArmPose.class, new Object[]{true, AoAArmPoses::attuningBowlTransformer});
    public static final EnumProxy<HumanoidModel.ArmPose> SMALL_GUN = new EnumProxy(HumanoidModel.ArmPose.class, new Object[]{true, AoAArmPoses::smallGunArmTransformer});
    public static final EnumProxy<HumanoidModel.ArmPose> LARGE_GUN = new EnumProxy(HumanoidModel.ArmPose.class, new Object[]{true, AoAArmPoses::largeGunArmTransformer});

    private static void attuningBowlTransformer(HumanoidModel<?> model, LivingEntity entity, HumanoidArm arm) {
        if (entity.getUseItem().is(AoATools.ATTUNING_BOWL)) {
            model.rightArm.xRot = -1.3089969f;
            model.rightArm.yRot = -0.47123888f;
            model.leftArm.xRot = -1.3089969f;
            model.leftArm.yRot = 0.47123888f;
        }
    }

    private static void smallGunArmTransformer(HumanoidModel<?> model, LivingEntity entity, HumanoidArm arm) {
        Mob mob;
        boolean rightHand = arm == HumanoidArm.RIGHT;
        ModelPart armModel = rightHand ? model.rightArm : model.leftArm;
        armModel.yRot = model.head.yRot;
        armModel.xRot = -1.5707964f + model.head.xRot + 0.1f;
        if (arm == (entity instanceof Mob && (mob = (Mob)entity).isLeftHanded() ? HumanoidArm.LEFT : HumanoidArm.RIGHT) && EnchantmentUtil.hasEnchantment(entity.level(), entity.getOffhandItem(), AoAEnchantments.BRACE)) {
            armModel = !rightHand ? model.rightArm : model.leftArm;
            armModel.yRot = model.head.yRot;
            armModel.xRot = -1.5707964f + model.head.xRot + 0.1f;
        }
    }

    private static void largeGunArmTransformer(HumanoidModel<?> model, LivingEntity entity, HumanoidArm arm) {
        Mob mob;
        HumanoidArm mainHand;
        HumanoidArm humanoidArm = mainHand = entity instanceof Mob && (mob = (Mob)entity).isLeftHanded() ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
        if (mainHand != arm) {
            return;
        }
        boolean rightHand = arm == HumanoidArm.RIGHT;
        ModelPart armModel = rightHand ? model.rightArm : model.leftArm;
        armModel.yRot = model.head.yRot;
        armModel.xRot = -1.5707964f + model.head.xRot + 0.1f;
        if (entity.getItemInHand(InteractionHand.OFF_HAND).isEmpty()) {
            ModelPart supportArmModel = rightHand ? model.leftArm : model.rightArm;
            supportArmModel.yRot = model.head.yRot + (rightHand ? 0.9f : -0.9f);
            supportArmModel.xRot = -1.5707964f + model.head.xRot + 0.2f;
        }
    }
}

