/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent;

import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.library.object.Text;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PositionAndMotionUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;

final class InDevMeasurements {
    private static Vec3 measurePos = null;

    InDevMeasurements() {
    }

    public static void init() {
        if (FMLEnvironment.production) {
            return;
        }
        NeoForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, PlayerInteractEvent.RightClickEmpty.class, InDevMeasurements::measureEmptyClick);
        NeoForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, PlayerInteractEvent.RightClickBlock.class, InDevMeasurements::measureBlockClick);
        NeoForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, PlayerInteractEvent.EntityInteractSpecific.class, InDevMeasurements::measureEntityClick);
        NeoForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, ClientTickEvent.Post.class, InDevMeasurements::doClientTick);
    }

    private static void doMeasurement(Player player, Optional<Vec3> hitPos) {
        Vec3 pos = hitPos.orElseGet(() -> PositionAndMotionUtil.rayTrace((Entity)player, 3.0, true, entity -> entity != player).getLocation());
        if (measurePos == null) {
            measurePos = pos;
        } else {
            player.sendSystemMessage((Component)Text.ofLiteral(NumberUtil.roundTo2Decimals((float)measurePos.distanceTo(pos)) + " blocks"));
            measurePos = null;
        }
    }

    private static void measureEmptyClick(PlayerInteractEvent.RightClickEmpty ev) {
        if (ev.getHand() == InteractionHand.MAIN_HAND && ev.getLevel().isClientSide && ev.getEntity().isCrouching()) {
            InDevMeasurements.doMeasurement(ev.getEntity(), Optional.empty());
        }
    }

    private static void measureBlockClick(PlayerInteractEvent.RightClickBlock ev) {
        if (ev.getHand() == InteractionHand.MAIN_HAND && ev.getLevel().isClientSide && ev.getEntity().isCrouching()) {
            InDevMeasurements.doMeasurement(ev.getEntity(), Optional.of(ev.getHitVec().getLocation()));
        }
    }

    private static void measureEntityClick(PlayerInteractEvent.EntityInteractSpecific ev) {
        if (ev.getHand() == InteractionHand.MAIN_HAND && ev.getLevel().isClientSide && ev.getEntity().isCrouching()) {
            InDevMeasurements.doMeasurement(ev.getEntity(), Optional.of(ev.getLocalPos().add(ev.getTarget().position())));
        }
    }

    private static void doClientTick(ClientTickEvent.Post ev) {
        Player player = ClientOperations.getPlayer();
        if (measurePos != null && player != null && player.isCrouching() && !(player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof BlockItem)) {
            ParticleBuilder.forPositionsInLine((ParticleOptions)ParticleTypes.END_ROD, (Vec3)measurePos, (Vec3)PositionAndMotionUtil.rayTrace((Entity)player, 3.0, true, entity -> entity != player).getLocation(), (int)32).lifespan(1).scaleMod(0.25f).velocity(Vec3.ZERO).spawnParticles(player.level());
        }
    }
}

