/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.function.Consumer;
import net.minecraft.core.RegistryAccess;
import org.jetbrains.annotations.Nullable;

public final class AoAResourceCaching {
    private static final Multimap<TaskType, Consumer<@Nullable RegistryAccess>> TASKS = MultimapBuilder.enumKeys(TaskType.class).arrayListValues().build();

    public static void onClientLogout(Runnable task) {
        TASKS.put((Object)TaskType.CLIENT_LOGOUT, registryAccess -> task.run());
    }

    public static void onDataReload(Consumer<RegistryAccess> task) {
        TASKS.put((Object)TaskType.DATAPACK_RELOAD, task);
    }

    public static void onClientLogoutAndReload(Consumer<@Nullable RegistryAccess> task) {
        AoAResourceCaching.onClientLogout(() -> task.accept(null));
        AoAResourceCaching.onDataReload(task);
    }

    public static void clientLogout() {
        for (Consumer task : TASKS.get((Object)TaskType.CLIENT_LOGOUT)) {
            task.accept(null);
        }
    }

    public static void datapackReload(RegistryAccess registryAccess) {
        for (Consumer task : TASKS.get((Object)TaskType.DATAPACK_RELOAD)) {
            task.accept(registryAccess);
        }
    }

    private static enum TaskType {
        CLIENT_LOGOUT,
        DATAPACK_RELOAD;

    }
}

