/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advancement.trigger;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.tslat.aoa3.common.registration.AoAAdvancementTriggers;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.player.skill.AoASkill;
import org.jetbrains.annotations.Nullable;

public class AoAXpGainTrigger
extends SimpleCriterionTrigger<Instance> {
    public Codec<Instance> codec() {
        return Instance.CODEC;
    }

    public void trigger(ServerPlayer player, AoASkill skill, float xp) {
        this.trigger(player, instance -> instance.test(skill, xp));
    }

    public static Criterion<Instance> onSkillXpGain(@Nullable ContextAwarePredicate conditions, @Nullable AoASkill skill, Optional<Float> xpThreshold) {
        return ((AoAXpGainTrigger)((Object)AoAAdvancementTriggers.XP_GAIN.get())).createCriterion((CriterionTriggerInstance)new Instance(Optional.ofNullable(conditions), skill != null ? Optional.of(skill) : Optional.empty(), xpThreshold));
    }

    public static Criterion<Instance> onSkillXpGain(@Nullable AoASkill skill, Optional<Float> xpThreshold) {
        return AoAXpGainTrigger.onSkillXpGain(null, skill, xpThreshold);
    }

    public static Criterion<Instance> onSkillXpGain(@Nullable AoASkill skill) {
        return AoAXpGainTrigger.onSkillXpGain(skill, Optional.empty());
    }

    public static Criterion<Instance> onSkillXpGain(Optional<Float> xpThreshold) {
        return AoAXpGainTrigger.onSkillXpGain(null, xpThreshold);
    }

    public record Instance(Optional<ContextAwarePredicate> player, Optional<AoASkill> skill, Optional<Float> xpThreshold) implements SimpleCriterionTrigger.SimpleInstance
    {
        private final Optional<ContextAwarePredicate> player;
        private static final Codec<Instance> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)AoARegistries.AOA_SKILLS.lookupCodec().optionalFieldOf("skill").forGetter(Instance::skill), (App)Codec.FLOAT.optionalFieldOf("xp").forGetter(Instance::xpThreshold)).apply((Applicative)codec, Instance::new));

        public boolean test(AoASkill skill, float xp) {
            return !(!this.skill().isEmpty() && this.skill().get() != skill || !this.xpThreshold().isEmpty() && !(this.xpThreshold().get().floatValue() <= xp));
        }

        public Optional<ContextAwarePredicate> player() {
            return Optional.empty();
        }
    }
}

