/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advancement.trigger;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.tslat.aoa3.common.registration.AoAAdvancementTriggers;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.player.skill.AoASkill;
import org.jetbrains.annotations.Nullable;

public class AoACycleTrigger
extends SimpleCriterionTrigger<Instance> {
    public Codec<Instance> codec() {
        return Instance.CODEC;
    }

    public void trigger(ServerPlayer player, AoASkill skill, int newLevel) {
        this.trigger(player, instance -> instance.test(skill, newLevel));
    }

    public static Criterion<Instance> onSkillCycle(@Nullable ContextAwarePredicate conditions, @Nullable AoASkill skill, Optional<Integer> cycle) {
        return ((AoACycleTrigger)((Object)AoAAdvancementTriggers.CYCLE_SKILL.get())).createCriterion((CriterionTriggerInstance)new Instance(Optional.ofNullable(conditions), skill != null ? Optional.of(skill) : Optional.empty(), cycle));
    }

    public static Criterion<Instance> onSkillCycle(@Nullable AoASkill skill, Optional<Integer> cycle) {
        return AoACycleTrigger.onSkillCycle(null, skill, cycle);
    }

    public static Criterion<Instance> onSkillCycle(@Nullable AoASkill skill) {
        return AoACycleTrigger.onSkillCycle(skill, Optional.empty());
    }

    public static Criterion<Instance> onSkillCycle(Optional<Integer> cycle) {
        return AoACycleTrigger.onSkillCycle(null, cycle);
    }

    public record Instance(Optional<ContextAwarePredicate> player, Optional<AoASkill> skill, Optional<Integer> cycle) implements SimpleCriterionTrigger.SimpleInstance
    {
        private final Optional<ContextAwarePredicate> player;
        private static final Codec<Instance> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)AoARegistries.AOA_SKILLS.lookupCodec().optionalFieldOf("skill").forGetter(Instance::skill), (App)Codec.intRange((int)1, (int)10).optionalFieldOf("cycle").forGetter(Instance::cycle)).apply((Applicative)codec, Instance::new));

        public boolean test(AoASkill skill, int level) {
            return !(!this.skill().isEmpty() && this.skill().get() != skill || !this.cycle().isEmpty() && level < this.cycle().get());
        }

        public Optional<ContextAwarePredicate> player() {
            return Optional.empty();
        }
    }
}

