/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.utils;

import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.tracen.umapyoi.registry.umadata.Motivations;
import net.tracen.umapyoi.utils.UmaSoulUtils;

public class UmaStatusUtils {
    public static Component getStatusLevel(int level) {
        return Component.translatable((String)("umastatus.level." + level));
    }

    public static void addMotivation(ItemStack stack) {
        Motivations motivation = UmaSoulUtils.getMotivation(stack);
        switch (motivation) {
            case PERFECT: {
                UmaSoulUtils.setMotivation(stack, Motivations.PERFECT);
                break;
            }
            case GOOD: {
                UmaSoulUtils.setMotivation(stack, Motivations.PERFECT);
                break;
            }
            case NORMAL: {
                UmaSoulUtils.setMotivation(stack, Motivations.GOOD);
                break;
            }
            case DOWN: {
                UmaSoulUtils.setMotivation(stack, Motivations.NORMAL);
                break;
            }
            case BAD: {
                UmaSoulUtils.setMotivation(stack, Motivations.DOWN);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected motivation value: " + String.valueOf((Object)motivation));
            }
        }
    }

    public static void downMotivation(ItemStack stack) {
        Motivations motivation = UmaSoulUtils.getMotivation(stack);
        switch (motivation) {
            case PERFECT: {
                UmaSoulUtils.setMotivation(stack, Motivations.GOOD);
                break;
            }
            case GOOD: {
                UmaSoulUtils.setMotivation(stack, Motivations.NORMAL);
                break;
            }
            case NORMAL: {
                UmaSoulUtils.setMotivation(stack, Motivations.DOWN);
                break;
            }
            case DOWN: {
                UmaSoulUtils.setMotivation(stack, Motivations.BAD);
                break;
            }
            case BAD: {
                UmaSoulUtils.setMotivation(stack, Motivations.BAD);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected motivation value: " + String.valueOf((Object)motivation));
            }
        }
    }

    public static enum StatusType {
        SPEED(0),
        STAMINA(1),
        STRENGTH(2),
        GUTS(3),
        WISDOM(4);

        private Integer id;

        private StatusType(Integer id) {
            this.id = id;
        }

        public Integer getId() {
            return this.id;
        }
    }
}

