/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.utils;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.tracen.umapyoi.registry.training.card.SupportCard;
import net.tracen.umapyoi.registry.umadata.UmaData;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class ClientUtils {
    public static final ResourceLocation TRAINNING_SUIT = ClientUtils.getModel("trainning_suit");
    public static final ResourceLocation SUMMER_UNIFORM = ClientUtils.getModel("summer_uniform");
    public static final ResourceLocation WINTER_UNIFORM = ClientUtils.getModel("winter_uniform");
    public static final ResourceLocation KINDERGARTEN_UNIFORM = ClientUtils.getModel("kindergarten_uniform");
    public static final ResourceLocation TRAINNING_SUIT_FLAT = ClientUtils.getModel("trainning_suit_flat");
    public static final ResourceLocation SUMMER_UNIFORM_FLAT = ClientUtils.getModel("summer_uniform_flat");
    public static final ResourceLocation WINTER_UNIFORM_FLAT = ClientUtils.getModel("winter_uniform_flat");
    public static final ResourceLocation THREE_GODDESS = ClientUtils.getModel("three_goddesses");
    public static final ResourceLocation UMA_STATUES = ClientUtils.getModel("uma_statue");
    public static final ResourceLocation SWIMSUIT = ClientUtils.getModel("swimsuit");
    public static final ResourceLocation SWIMSUIT_FLAT = ClientUtils.getModel("swimsuit_flat");

    public static ResourceLocation getModel(String name) {
        return ClientUtils.getModel("umapyoi", name);
    }

    public static ResourceLocation getModel(String modid, String name) {
        return ResourceLocation.fromNamespaceAndPath((String)modid, (String)name);
    }

    public static ResourceLocation getTexture(ResourceLocation name) {
        return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("textures/model/" + name.getPath() + ".png"));
    }

    public static ResourceLocation getEmissiveTexture(ResourceLocation name) {
        return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("textures/model/" + name.getPath() + "_emissive.png"));
    }

    public static Registry<UmaData> getClientUmaDataRegistry() {
        return Minecraft.getInstance().getConnection().registryAccess().registryOrThrow(UmaData.REGISTRY_KEY);
    }

    public static Registry<SupportCard> getClientSupportCardRegistry() {
        return Minecraft.getInstance().getConnection().registryAccess().registryOrThrow(SupportCard.REGISTRY_KEY);
    }

    public static void addSummonParticle(Level pLevel, BlockPos pPos) {
        RandomSource pRand = pLevel.getRandom();
        List<BlockPos> posOffsets = BlockPos.betweenClosedStream((int)-1, (int)-1, (int)-1, (int)1, (int)0, (int)1).filter(pos -> Math.abs(pos.getX()) == 1 || Math.abs(pos.getZ()) == 1).map(BlockPos::immutable).toList();
        for (BlockPos spawnPos : posOffsets) {
            if (pRand.nextInt(32) != 0) continue;
            pLevel.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)pPos.getX() + 0.5, (double)pPos.getY() + 2.65, (double)pPos.getZ() + 0.5, (double)((float)spawnPos.getX() + pRand.nextFloat()) - 0.5, (double)spawnPos.getY() + 1.0 - (double)pRand.nextFloat(), (double)((float)spawnPos.getZ() + pRand.nextFloat()) - 0.5);
        }
    }

    public static void renderModelInInventory(GuiGraphics guiGraphic, int x, int y, int scale, Quaternionf pose, Model pModel, ResourceLocation texture) {
        guiGraphic.pose().pushPose();
        guiGraphic.pose().translate((double)x, (double)y, 50.0);
        guiGraphic.pose().scale((float)scale, (float)scale, (float)(-scale));
        guiGraphic.pose().mulPose(pose);
        MultiBufferSource.BufferSource buffersource = guiGraphic.bufferSource();
        VertexConsumer vertexconsumer = buffersource.getBuffer(RenderType.entityTranslucent((ResourceLocation)ClientUtils.getTexture(texture)));
        pModel.renderToBuffer(guiGraphic.pose(), vertexconsumer, 0xF000F0, OverlayTexture.NO_OVERLAY);
        guiGraphic.flush();
        guiGraphic.pose().popPose();
    }
}

