/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.registry.training;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.tracen.umapyoi.events.ApplyTrainingSupportEvent;
import net.tracen.umapyoi.registry.TrainingSupportRegistry;
import net.tracen.umapyoi.registry.training.TrainingSupport;

public class SupportStack {
    private final TrainingSupport factor;
    private final int level;
    @Nullable
    private CompoundTag tag;
    public static final Codec<SupportStack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TrainingSupport.CODEC.fieldOf("support").forGetter(SupportStack::getFactor), (App)Codec.INT.fieldOf("level").forGetter(SupportStack::getLevel), (App)CompoundTag.CODEC.optionalFieldOf("tag").forGetter(stack -> Optional.ofNullable(stack.getTag()))).apply((Applicative)instance, SupportStack::new));
    public static final SupportStack EMPTY = new SupportStack(null, 0);

    public SupportStack(TrainingSupport factor, int level) {
        this.factor = factor;
        this.level = level;
    }

    public SupportStack(TrainingSupport factor, int level, CompoundTag nbt) {
        this(factor, level);
        if (nbt != null) {
            this.tag = nbt.copy();
        }
    }

    public SupportStack(TrainingSupport factor, int level, Optional<CompoundTag> nbt) {
        this(factor, level);
        nbt.ifPresent(this::setTag);
    }

    public TrainingSupport getFactor() {
        return this.factor;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isEmpty() {
        if (this == EMPTY) {
            return true;
        }
        if (this.getFactor() != null) {
            return this.getLevel() <= 0;
        }
        return true;
    }

    public boolean applySupport(ItemStack soul) {
        if (!((ApplyTrainingSupportEvent.Pre)NeoForge.EVENT_BUS.post((Event)new ApplyTrainingSupportEvent.Pre(this, soul))).isCanceled()) {
            boolean result = this.getFactor().applySupport(soul, this);
            return result && !((ApplyTrainingSupportEvent.Post)NeoForge.EVENT_BUS.post((Event)new ApplyTrainingSupportEvent.Post(this, soul))).isCanceled();
        }
        return false;
    }

    public Component getDescription() {
        return this.getFactor().getDescription(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SupportStack) {
            SupportStack stack = (SupportStack)obj;
            return stack.level == this.level && stack.factor == this.factor;
        }
        return false;
    }

    public int hashCode() {
        int code = 31 * Integer.hashCode(this.getLevel()) + TrainingSupportRegistry.REGISTRY.getKey((Object)this.getFactor()).hashCode();
        if (this.tag != null) {
            code = 31 * code + this.tag.hashCode();
        }
        return code;
    }

    public String toString() {
        return String.format("level:%d, support:%s", this.getLevel(), this.factor);
    }

    public boolean hasTag() {
        return this.tag != null && !this.tag.isEmpty();
    }

    @Nullable
    public CompoundTag getTag() {
        return this.tag;
    }

    public CompoundTag getOrCreateTag() {
        if (this.tag == null) {
            this.setTag(new CompoundTag());
        }
        return this.tag;
    }

    public CompoundTag getOrCreateTagElement(String pKey) {
        if (this.tag != null && this.tag.contains(pKey, 10)) {
            return this.tag.getCompound(pKey);
        }
        CompoundTag compoundtag = new CompoundTag();
        this.addTagElement(pKey, (Tag)compoundtag);
        return compoundtag;
    }

    @Nullable
    public CompoundTag getTagElement(String pKey) {
        return this.tag != null && this.tag.contains(pKey, 10) ? this.tag.getCompound(pKey) : null;
    }

    public void addTagElement(String pKey, Tag pTag) {
        this.getOrCreateTag().put(pKey, pTag);
    }

    public void removeTagKey(String pKey) {
        if (this.tag != null && this.tag.contains(pKey)) {
            this.tag.remove(pKey);
            if (this.tag.isEmpty()) {
                this.tag = null;
            }
        }
    }

    public void setTag(@Nullable CompoundTag tag) {
        this.tag = tag;
    }
}

