/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.ServerPayloadContext;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.events.SkillEvent;
import net.tracen.umapyoi.registry.UmaSkillRegistry;
import net.tracen.umapyoi.registry.skills.UmaSkill;
import net.tracen.umapyoi.utils.UmaSoulUtils;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public record UseSkillPacket(String message) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UseSkillPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"umapyoi", (String)"use_skill"));
    public static final StreamCodec<ByteBuf, UseSkillPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, UseSkillPacket::message, UseSkillPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(UseSkillPacket payload, IPayloadContext context) {
        if (context instanceof ServerPayloadContext) {
            ServerPayloadContext serverCtx = (ServerPayloadContext)context;
            context.enqueueWork(() -> {
                ServerPlayer player = serverCtx.player();
                if (player.isSpectator()) {
                    return;
                }
                ItemStack umaSoul = UmapyoiAPI.getUmaSoul((LivingEntity)player);
                if (!umaSoul.isEmpty()) {
                    ResourceLocation selectedSkillName = UmaSoulUtils.getSelectedSkill(umaSoul);
                    UmaSkill selectedSkill = (UmaSkill)UmaSkillRegistry.REGISTRY.get(selectedSkillName);
                    if (selectedSkill == null) {
                        player.displayClientMessage((Component)Component.translatable((String)"umapyoi.unknown_skill"), true);
                        return;
                    }
                    if (((SkillEvent.UseSkillEvent)NeoForge.EVENT_BUS.post((Event)new SkillEvent.UseSkillEvent(selectedSkillName, player.level(), (Player)player))).isCanceled()) {
                        return;
                    }
                    int ap = UmaSoulUtils.getActionPoint(umaSoul);
                    if (ap >= selectedSkill.getActionPoint()) {
                        player.connection.send((Packet)new ClientboundSoundPacket((Holder)BuiltInRegistries.SOUND_EVENT.getHolder(selectedSkill.getSound().getLocation()).get(), SoundSource.PLAYERS, player.getX(), player.getY(), player.getZ(), 1.0f, 1.0f, player.getRandom().nextLong()));
                        selectedSkill.applySkill(player.level(), (LivingEntity)player);
                        UmaSoulUtils.setActionPoint(umaSoul, ap - selectedSkill.getActionPoint());
                        NeoForge.EVENT_BUS.post((Event)new SkillEvent.ApplySkillEvent(UmaSkillRegistry.REGISTRY.getKey((Object)selectedSkill), player.level(), (Player)player));
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"umapyoi.not_enough_ap"), true);
                    }
                }
            });
        }
    }
}

