/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tracen.umapyoi.Umapyoi;
import net.tracen.umapyoi.data.builtin.UmaDataRegistry;
import net.tracen.umapyoi.data.tag.UmapyoiItemTags;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.item.data.DataLocation;
import net.tracen.umapyoi.registry.training.card.SupportCard;
import net.tracen.umapyoi.utils.TrainingSupportUtils;
import net.tracen.umapyoi.utils.UmaSoulUtils;

public class UmaTicketItem
extends Item {
    public UmaTicketItem() {
        super(Umapyoi.defaultItemProperties());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (stack.has(DataComponentsTypeRegistry.DATA_LOCATION)) {
            if (stack.is(UmapyoiItemTags.CARD_TICKET)) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.umapyoi.support_card.name", (Object[])new Object[]{TrainingSupportUtils.getTranslatedSupportCardName(this.getSupportCardID(stack))}).withStyle(ChatFormatting.GRAY));
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.umapyoi.umadata.name", (Object[])new Object[]{UmaSoulUtils.getTranslatedUmaName(this.getUmaName(stack))}).withStyle(ChatFormatting.GRAY));
            }
        }
    }

    public ResourceLocation getUmaName(ItemStack stack) {
        return Optional.ofNullable(((DataLocation)stack.get(DataComponentsTypeRegistry.DATA_LOCATION)).name()).orElse(UmaDataRegistry.COMMON_UMA.location());
    }

    public boolean isFoil(ItemStack stack) {
        return stack.has(DataComponentsTypeRegistry.DATA_LOCATION);
    }

    private ResourceLocation getSupportCardID(ItemStack stack) {
        if (stack.has(DataComponentsTypeRegistry.DATA_LOCATION)) {
            return ((DataLocation)stack.get(DataComponentsTypeRegistry.DATA_LOCATION)).name();
        }
        return SupportCard.EMPTY_ID;
    }
}

