/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.item;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.tracen.umapyoi.Umapyoi;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.registry.umadata.UmaData;
import net.tracen.umapyoi.registry.umadata.UmaDataBasicStatus;
import net.tracen.umapyoi.utils.GachaRanking;
import net.tracen.umapyoi.utils.ResultRankingUtils;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import net.tracen.umapyoi.utils.UmaStatusUtils;

public class UmaSoulItem
extends Item {
    private static final Comparator<Holder.Reference<UmaData>> COMPARATOR = new UmaDataComparator();

    public UmaSoulItem() {
        super(Umapyoi.defaultItemProperties().stacksTo(1));
    }

    public static Stream<Holder.Reference<UmaData>> sortedUmaDataList(HolderLookup.Provider provider) {
        return provider.lookupOrThrow(UmaData.REGISTRY_KEY).listElements().sorted(COMPARATOR);
    }

    public Component getName(ItemStack pStack) {
        GachaRanking ranking = GachaRanking.getGachaRanking(pStack);
        if (ranking == GachaRanking.EASTER_EGG) {
            return super.getName(pStack).copy().withStyle(ChatFormatting.GREEN);
        }
        return super.getName(pStack);
    }

    public String getDescriptionId(ItemStack pStack) {
        return Util.makeDescriptionId((String)"umadata", (ResourceLocation)UmaSoulUtils.getName(pStack));
    }

    public boolean isFoil(ItemStack pStack) {
        return !pStack.has(DataComponentsTypeRegistry.UMADATA_TRAINING);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        int ranking = ResultRankingUtils.getRanking(stack);
        if (!stack.has(DataComponentsTypeRegistry.UMADATA_TRAINING)) {
            tooltip.add((Component)Component.translatable((String)"tooltip.umapyoi.uma_soul.ranking", (Object[])new Object[]{UmaStatusUtils.getStatusLevel(ranking)}).withStyle(ChatFormatting.GOLD));
        }
        if (Screen.hasShiftDown() || !((Boolean)UmapyoiConfig.TOOLTIP_SWITCH.get()).booleanValue()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.umapyoi.uma_soul.soul_details").withStyle(ChatFormatting.AQUA));
            UmaDataBasicStatus property = UmaSoulUtils.getProperty(stack);
            UmaDataBasicStatus maxProperty = UmaSoulUtils.getMaxProperty(stack);
            tooltip.add((Component)Component.translatable((String)"tooltip.umapyoi.uma_soul.speed_details", (Object[])new Object[]{UmaStatusUtils.getStatusLevel(property.speed()), UmaStatusUtils.getStatusLevel(maxProperty.speed())}).withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.translatable((String)"tooltip.umapyoi.uma_soul.stamina_details", (Object[])new Object[]{UmaStatusUtils.getStatusLevel(property.stamina()), UmaStatusUtils.getStatusLevel(maxProperty.stamina())}).withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.translatable((String)"tooltip.umapyoi.uma_soul.strength_details", (Object[])new Object[]{UmaStatusUtils.getStatusLevel(property.strength()), UmaStatusUtils.getStatusLevel(maxProperty.strength())}).withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.translatable((String)"tooltip.umapyoi.uma_soul.guts_details", (Object[])new Object[]{UmaStatusUtils.getStatusLevel(property.guts()), UmaStatusUtils.getStatusLevel(maxProperty.guts())}).withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.translatable((String)"tooltip.umapyoi.uma_soul.wisdom_details", (Object[])new Object[]{UmaStatusUtils.getStatusLevel(property.wisdom()), UmaStatusUtils.getStatusLevel(maxProperty.wisdom())}).withStyle(ChatFormatting.DARK_GREEN));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.umapyoi.press_shift_for_details").withStyle(ChatFormatting.AQUA));
        }
    }

    private static class UmaDataComparator
    implements Comparator<Holder.Reference<UmaData>> {
        private UmaDataComparator() {
        }

        @Override
        public int compare(Holder.Reference<UmaData> left, Holder.Reference<UmaData> right) {
            GachaRanking rightRanking;
            GachaRanking leftRanking = ((UmaData)left.value()).ranking();
            if (leftRanking == (rightRanking = ((UmaData)right.value()).ranking())) {
                String leftName = left.key().location().toString();
                String rightName = right.key().location().toString();
                return leftName.compareToIgnoreCase(rightName);
            }
            return leftRanking.compareTo(rightRanking);
        }
    }
}

