/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.item;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tracen.umapyoi.Umapyoi;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.item.data.DataLocation;
import net.tracen.umapyoi.registry.factors.UmaFactorStack;
import net.tracen.umapyoi.utils.UmaFactorUtils;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class UmaFactorContainerItem
extends Item {
    public UmaFactorContainerItem() {
        super(Umapyoi.defaultItemProperties().stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        List datas = (List)stack.get(DataComponentsTypeRegistry.FACTOR_DATA);
        String buffer = "umadata." + ((DataLocation)stack.get(DataComponentsTypeRegistry.DATA_LOCATION)).name().toLanguageKey();
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.umapyoi.umadata.name", (Object[])new Object[]{I18n.get((String)buffer, (Object[])new Object[0])}).withStyle(ChatFormatting.GRAY));
        if (Screen.hasShiftDown() || !((Boolean)UmapyoiConfig.TOOLTIP_SWITCH.get()).booleanValue()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.umapyoi.factors.factors_details").withStyle(ChatFormatting.AQUA));
            List<UmaFactorStack> stackList = UmaFactorUtils.deserializeData(datas);
            stackList.forEach(factor -> {
                switch (factor.getFactor().getFactorType()) {
                    case STATUS: {
                        tooltipComponents.add((Component)factor.getDescription().copy().withStyle(ChatFormatting.BLUE));
                        break;
                    }
                    case UNIQUE: {
                        tooltipComponents.add((Component)factor.getDescription().copy().withStyle(ChatFormatting.GREEN));
                        break;
                    }
                    case EXTRASTATUS: {
                        tooltipComponents.add((Component)factor.getDescription().copy().withStyle(ChatFormatting.RED));
                        break;
                    }
                    default: {
                        tooltipComponents.add((Component)factor.getDescription().copy().withStyle(ChatFormatting.GRAY));
                    }
                }
            });
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.umapyoi.press_shift_for_details").withStyle(ChatFormatting.AQUA));
        }
    }
}

