/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.item;

import com.google.common.base.Suppliers;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tracen.umapyoi.Umapyoi;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.data.tag.UmapyoiItemTags;
import net.tracen.umapyoi.item.UmaSoulItem;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.item.data.DataLocation;
import net.tracen.umapyoi.registry.training.SupportContainer;
import net.tracen.umapyoi.registry.training.SupportStack;
import net.tracen.umapyoi.registry.training.SupportType;
import net.tracen.umapyoi.registry.training.card.SupportCard;
import net.tracen.umapyoi.registry.umadata.UmaData;
import net.tracen.umapyoi.utils.ClientUtils;
import net.tracen.umapyoi.utils.GachaRanking;
import net.tracen.umapyoi.utils.UmaSoulUtils;

public class SupportCardItem
extends Item
implements SupportContainer {
    private static final Comparator<Holder.Reference<SupportCard>> COMPARATOR = new CardDataComparator();

    public SupportCardItem() {
        super(Umapyoi.defaultItemProperties().stacksTo(1));
    }

    public static Stream<Holder.Reference<SupportCard>> sortedCardDataList(HolderLookup.Provider provider) {
        return provider.lookupOrThrow(SupportCard.REGISTRY_KEY).listElements().sorted(COMPARATOR);
    }

    public ItemStack getDefaultInstance() {
        return SupportCard.init(SupportCard.EMPTY_ID, SupportCard.EMPTY);
    }

    public boolean isValidRepairItem(ItemStack pToRepair, ItemStack pRepair) {
        return pRepair.is(UmapyoiItemTags.HORSESHOE) || super.isValidRepairItem(pToRepair, pRepair);
    }

    public String getDescriptionId(ItemStack pStack) {
        return Util.makeDescriptionId((String)"support_card", (ResourceLocation)this.getSupportCardID(pStack)) + ".name";
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        ResourceLocation cardID = this.getSupportCardID(stack);
        if (this.isEmptyCard(context.level(), cardID)) {
            return;
        }
        if (Screen.hasShiftDown() || !((Boolean)UmapyoiConfig.TOOLTIP_SWITCH.get()).booleanValue()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.umapyoi.supports").withStyle(ChatFormatting.AQUA));
            this.getSupports(context.level(), stack).forEach(support -> tooltip.add((Component)support.getDescription().copy().withStyle(ChatFormatting.GRAY)));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.umapyoi.support_card.press_shift_for_supports").withStyle(ChatFormatting.AQUA));
        }
        List<ResourceLocation> supporters = ((SupportCard)ClientUtils.getClientSupportCardRegistry().get(cardID)).getSupporters();
        if (!supporters.isEmpty()) {
            if (Screen.hasControlDown() || !((Boolean)UmapyoiConfig.TOOLTIP_SWITCH.get()).booleanValue()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.umapyoi.supporters").withStyle(ChatFormatting.AQUA));
                supporters.forEach(name -> tooltip.add((Component)UmaSoulUtils.getTranslatedUmaName(name).copy().withStyle(ChatFormatting.GRAY)));
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.umapyoi.support_card.press_ctrl_for_supporters").withStyle(ChatFormatting.AQUA));
            }
        }
    }

    public ResourceLocation getSupportCardID(ItemStack stack) {
        if (stack.has(DataComponentsTypeRegistry.DATA_LOCATION)) {
            return ((DataLocation)stack.get(DataComponentsTypeRegistry.DATA_LOCATION)).name();
        }
        return SupportCard.EMPTY_ID;
    }

    public SupportCard getSupportCard(Level level, ItemStack stack) {
        ResourceLocation cardID = this.getSupportCardID(stack);
        if (this.isEmptyCard(level, cardID)) {
            return SupportCard.EMPTY;
        }
        return (SupportCard)UmapyoiAPI.getSupportCardRegistry(level).get(cardID);
    }

    private boolean isEmptyCard(Level level, ResourceLocation cardID) {
        return level == null || cardID.equals((Object)SupportCard.EMPTY_ID) || !UmapyoiAPI.getSupportCardRegistry(level).containsKey(cardID);
    }

    @Override
    public boolean isConsumable(Level level, ItemStack stack) {
        return false;
    }

    @Override
    public GachaRanking getSupportLevel(Level level, ItemStack stack) {
        if (level == null) {
            return GachaRanking.R;
        }
        return this.getSupportCard(level, stack).getGachaRanking();
    }

    @Override
    public SupportType getSupportType(Level level, ItemStack stack) {
        return this.getSupportCard(level, stack).getSupportType();
    }

    @Override
    public List<SupportStack> getSupports(Level level, ItemStack stack) {
        return (List)Suppliers.memoize(this.getSupportCard(level, stack)::getSupportStacks).get();
    }

    @Override
    public Predicate<ItemStack> canSupport(Level level, ItemStack stack) {
        return itemstack -> {
            if (level == null) {
                return false;
            }
            Item item = itemstack.getItem();
            if (item instanceof UmaSoulItem) {
                UmaData data = (UmaData)UmapyoiAPI.getUmaDataRegistry(level).get(UmaSoulUtils.getName(itemstack));
                return !this.getSupportCard(level, stack).getSupporters().contains(data.identifier());
            }
            if (item instanceof SupportCardItem) {
                return this.checkSupports(level, stack, (ItemStack)itemstack);
            }
            return true;
        };
    }

    public boolean checkSupports(Level level, ItemStack stack, ItemStack other) {
        if (stack.getItem() instanceof SupportCardItem) {
            ResourceLocation otherCardID;
            ResourceLocation supportCardID = this.getSupportCardID(stack);
            if (supportCardID.equals((Object)(otherCardID = this.getSupportCardID(other)))) {
                return false;
            }
            SupportCard supportCard = this.getSupportCard(level, stack);
            SupportCard otherCard = this.getSupportCard(level, other);
            for (ResourceLocation name : supportCard.getSupporters()) {
                if (!otherCard.getSupporters().contains(name)) continue;
                return false;
            }
        }
        return true;
    }

    private static class CardDataComparator
    implements Comparator<Holder.Reference<SupportCard>> {
        private CardDataComparator() {
        }

        @Override
        public int compare(Holder.Reference<SupportCard> left, Holder.Reference<SupportCard> right) {
            GachaRanking rightRanking;
            GachaRanking leftRanking = ((SupportCard)left.value()).getGachaRanking();
            if (leftRanking == (rightRanking = ((SupportCard)right.value()).getGachaRanking())) {
                String leftName = left.key().location().toString();
                String rightName = right.key().location().toString();
                return leftName.compareToIgnoreCase(rightName);
            }
            return leftRanking.compareTo(rightRanking);
        }
    }
}

