/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.inventory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class CommonItemHandler
implements IItemHandler {
    private final int slots_input;
    private final int slot_output;
    private final IItemHandler itemHandler;
    private final Direction side;

    public CommonItemHandler(IItemHandler itemHandler, @Nullable Direction side, int inputs, int output) {
        this.itemHandler = itemHandler;
        this.side = side;
        this.slots_input = inputs;
        this.slot_output = output;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.itemHandler.isItemValid(slot, stack);
    }

    public int getSlots() {
        return this.itemHandler.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.side == null || this.side.equals((Object)Direction.UP)) {
            return slot < this.slots_input ? this.itemHandler.insertItem(slot, stack, simulate) : stack;
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.side == null || this.side.equals((Object)Direction.UP)) {
            return slot < this.slots_input ? this.itemHandler.extractItem(slot, amount, simulate) : ItemStack.EMPTY;
        }
        return slot == this.slot_output ? this.itemHandler.extractItem(slot, amount, simulate) : ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        return this.itemHandler.getSlotLimit(slot);
    }
}

