/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.events.handler;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.data.tag.UmapyoiBlockTags;
import net.tracen.umapyoi.events.ApplyUmasoulAttributeEvent;
import net.tracen.umapyoi.registry.UmaSkillRegistry;
import net.tracen.umapyoi.utils.UmaSoulUtils;

@EventBusSubscriber
public class PassiveSkillEvents {
    public static final ResourceLocation SKILL_HEIGHT = ResourceLocation.fromNamespaceAndPath((String)"umapyoi", (String)"passive_skill_height");
    public static final ResourceLocation SKILL_TURF = ResourceLocation.fromNamespaceAndPath((String)"umapyoi", (String)"passive_skill_turf");
    public static final ResourceLocation SKILL_DIRT = ResourceLocation.fromNamespaceAndPath((String)"umapyoi", (String)"passive_skill_dirt");
    public static final ResourceLocation SKILL_SNOW = ResourceLocation.fromNamespaceAndPath((String)"umapyoi", (String)"passive_skill_snow");
    public static final ResourceLocation SKILL_IM = ResourceLocation.fromNamespaceAndPath((String)"umapyoi", (String)"passive_inquisitive_mind");

    @SubscribeEvent
    public static void testPassiveSkill_im(ApplyUmasoulAttributeEvent event) {
        ItemStack soul = event.getUmaSoul();
        if (UmaSoulUtils.hasSkill(soul, UmaSkillRegistry.INQUISITIVE_MIND.getId())) {
            boolean speedFlag = UmaSoulUtils.getProperty(soul).speed() >= 12;
            boolean wisdomFlag = UmaSoulUtils.getProperty(soul).wisdom() >= 12;
            event.getAttributes().put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(SKILL_IM, speedFlag && wisdomFlag ? 0.075 : 0.05, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
    }

    @SubscribeEvent
    public static void testPassiveSkill_att(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        ItemStack soul = UmapyoiAPI.getUmaSoul((LivingEntity)player);
        if (UmaSoulUtils.hasSkill(soul, UmaSkillRegistry.DIG_SPEED.getId())) {
            event.setNewSpeed(event.getOriginalSpeed() * 1.1f);
        }
    }

    @SubscribeEvent
    public static void passiveStepHeight(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        AttributeInstance stepHeight = player.getAttribute(Attributes.STEP_HEIGHT);
        AttributeModifier heightModifier = new AttributeModifier(SKILL_HEIGHT, 0.5, AttributeModifier.Operation.ADD_VALUE);
        if (UmapyoiAPI.getUmaSoul((LivingEntity)player).isEmpty()) {
            stepHeight.removeModifier(heightModifier);
            return;
        }
        if (UmaSoulUtils.hasSkill(UmapyoiAPI.getUmaSoul((LivingEntity)player), UmaSkillRegistry.MOUNTAIN_CLIMBER.getId())) {
            if (!stepHeight.hasModifier(SKILL_HEIGHT)) {
                stepHeight.addTransientModifier(heightModifier);
            }
        } else {
            stepHeight.removeModifier(heightModifier);
        }
    }

    @SubscribeEvent
    public static void passiveTurfRunner(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        AttributeInstance movementSpeed = player.getAttribute(Attributes.MOVEMENT_SPEED);
        AttributeModifier test_speed = new AttributeModifier(SKILL_TURF, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        if (UmapyoiAPI.getUmaSoul((LivingEntity)player).isEmpty()) {
            movementSpeed.removeModifier(test_speed);
            return;
        }
        BlockPos groundPos = player.getY() % 1.0 < 0.5 ? player.blockPosition().below() : player.blockPosition();
        BlockState groundBlock = player.level().getBlockState(groundPos);
        if (UmaSoulUtils.hasSkill(UmapyoiAPI.getUmaSoul((LivingEntity)player), UmaSkillRegistry.TURF_RUNNER.getId())) {
            PassiveSkillEvents.handleMovementModifier(movementSpeed, test_speed, groundBlock, UmapyoiBlockTags.TRACK_TURF);
        }
    }

    @SubscribeEvent
    public static void passiveDirtRunner(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        AttributeInstance movementSpeed = player.getAttribute(Attributes.MOVEMENT_SPEED);
        AttributeModifier test_speed = new AttributeModifier(SKILL_DIRT, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        if (UmapyoiAPI.getUmaSoul((LivingEntity)player).isEmpty()) {
            movementSpeed.removeModifier(test_speed);
            return;
        }
        BlockPos groundPos = player.getY() % 1.0 < 0.5 ? player.blockPosition().below() : player.blockPosition();
        BlockState groundBlock = player.level().getBlockState(groundPos);
        if (UmaSoulUtils.hasSkill(UmapyoiAPI.getUmaSoul((LivingEntity)player), UmaSkillRegistry.DIRT_RUNNER.getId())) {
            PassiveSkillEvents.handleMovementModifier(movementSpeed, test_speed, groundBlock, UmapyoiBlockTags.TRACK_DIRT);
        }
    }

    @SubscribeEvent
    public static void passiveSnowRunner(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        AttributeInstance movementSpeed = player.getAttribute(Attributes.MOVEMENT_SPEED);
        AttributeModifier test_speed = new AttributeModifier(SKILL_SNOW, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        if (UmapyoiAPI.getUmaSoul((LivingEntity)player).isEmpty()) {
            movementSpeed.removeModifier(test_speed);
            return;
        }
        BlockPos groundPos = player.getY() % 1.0 < 0.5 ? player.blockPosition().below() : player.blockPosition();
        BlockState groundBlock = player.level().getBlockState(groundPos);
        if (UmaSoulUtils.hasSkill(UmapyoiAPI.getUmaSoul((LivingEntity)player), UmaSkillRegistry.SNOW_RUNNER.getId())) {
            PassiveSkillEvents.handleMovementModifier(movementSpeed, test_speed, groundBlock, player.getBlockStateOn(), UmapyoiBlockTags.TRACK_SNOW);
        }
    }

    private static void handleMovementModifier(AttributeInstance attribute, AttributeModifier modifier, BlockState groundBlock, TagKey<Block> tagIn) {
        PassiveSkillEvents.handleMovementModifier(attribute, modifier, groundBlock, groundBlock, tagIn);
    }

    private static void handleMovementModifier(AttributeInstance attribute, AttributeModifier modifier, BlockState groundBlock, BlockState feetblock, TagKey<Block> tagIn) {
        if (groundBlock.isAir() && feetblock.isAir()) {
            return;
        }
        if (!groundBlock.is(tagIn) && !feetblock.is(tagIn)) {
            if (attribute.hasModifier(modifier.id())) {
                attribute.removeModifier(modifier);
            }
            return;
        }
        if (!attribute.hasModifier(modifier.id())) {
            attribute.addTransientModifier(modifier);
        }
    }
}

