/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.events.handler;

import cn.mcmod_mmf.mmlib.client.model.pojo.BedrockModelPOJO;
import cn.mcmod_mmf.mmlib.utils.ClientUtil;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderArmEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.client.model.UmaPlayerModel;
import net.tracen.umapyoi.events.client.RenderingUmaSoulEvent;
import net.tracen.umapyoi.utils.UmaSoulUtils;

@EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    private static NonNullList<ItemStack> armor;
    private static final UmaPlayerModel<LivingEntity> baseModel;

    @SubscribeEvent
    public static void preUmaSoulRendering(RenderingUmaSoulEvent.Pre event) {
        LivingEntity entity = event.getWearer();
        UmaPlayerModel<LivingEntity> model = event.getModel();
        if (UmapyoiAPI.isUmaSuitRendering(entity)) {
            model.setAllVisible(false);
            model.head.visible = true;
            model.tail.visible = true;
            model.hat.visible = true;
        } else {
            model.setAllVisible(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerRendering(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        ItemStack umasoul = UmapyoiAPI.getRenderingUmaSoul((LivingEntity)event.getEntity());
        if (!umasoul.isEmpty()) {
            ((PlayerModel)event.getRenderer().getModel()).setAllVisible(false);
            if (!((Boolean)UmapyoiConfig.VANILLA_ARMOR_RENDER.get()).booleanValue() && !umasoul.isEmpty()) {
                armor = NonNullList.create();
                for (int i = 0; i < player.getInventory().armor.size(); ++i) {
                    armor.add((Object)((ItemStack)player.getInventory().armor.get(i)).copy());
                    if (((Boolean)UmapyoiConfig.ELYTRA_RENDER.get()).booleanValue() && ((ItemStack)player.getInventory().armor.get(i)).getItem() instanceof ElytraItem) {
                        player.getInventory().armor.set(i, (Object)((ItemStack)player.getInventory().armor.get(i)));
                        continue;
                    }
                    player.getInventory().armor.set(i, (Object)ItemStack.EMPTY);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRenderingPost(RenderPlayerEvent.Post event) {
        Player player = event.getEntity();
        ItemStack umasoul = UmapyoiAPI.getRenderingUmaSoul((LivingEntity)event.getEntity());
        if (!((Boolean)UmapyoiConfig.VANILLA_ARMOR_RENDER.get()).booleanValue() && armor != null && !umasoul.isEmpty()) {
            for (int i = 0; i < player.getInventory().armor.size(); ++i) {
                player.getInventory().armor.set(i, (Object)((ItemStack)armor.get(i)));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerArmRendering(RenderArmEvent event) {
        AbstractClientPlayer player = event.getPlayer();
        ItemStack umasoul = UmapyoiAPI.getRenderingUmaSoul((LivingEntity)player);
        if (!umasoul.isEmpty()) {
            ResourceLocation name = UmaSoulUtils.getName(umasoul);
            VertexConsumer vertexconsumer = event.getMultiBufferSource().getBuffer(RenderType.entityTranslucent((ResourceLocation)ClientEvents.getTexture(name)));
            BedrockModelPOJO pojo = ClientUtil.getModelPOJO((ResourceLocation)name);
            if (baseModel.needRefresh(pojo)) {
                baseModel.loadModel(pojo);
            }
            baseModel.setModelProperties((LivingEntity)event.getPlayer());
            ClientEvents.baseModel.attackTime = 0.0f;
            ClientEvents.baseModel.crouching = false;
            ClientEvents.baseModel.swimAmount = 0.0f;
            baseModel.setupAnim((LivingEntity)event.getPlayer(), 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            if (event.getArm() == HumanoidArm.RIGHT) {
                ClientEvents.baseModel.rightArm.xRot = 0.0f;
                ClientEvents.baseModel.rightArm.x -= 1.0f;
                ClientEvents.baseModel.rightArm.render(event.getPoseStack(), vertexconsumer, event.getPackedLight(), OverlayTexture.NO_OVERLAY);
                ClientEvents.baseModel.rightArm.x += 1.0f;
            } else {
                ClientEvents.baseModel.leftArm.xRot = 0.0f;
                ClientEvents.baseModel.leftArm.x += 1.0f;
                ClientEvents.baseModel.leftArm.render(event.getPoseStack(), vertexconsumer, event.getPackedLight(), OverlayTexture.NO_OVERLAY);
                ClientEvents.baseModel.leftArm.x -= 1.0f;
            }
            event.setCanceled(true);
        }
    }

    private static ResourceLocation getTexture(ResourceLocation name) {
        return ResourceLocation.tryBuild((String)name.getNamespace(), (String)("textures/model/" + name.getPath() + ".png"));
    }

    static {
        baseModel = new UmaPlayerModel();
    }
}

