/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.container;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.tracen.umapyoi.block.BlockRegistry;
import net.tracen.umapyoi.block.entity.ThreeGoddessBlockEntity;
import net.tracen.umapyoi.container.CommonResultSlot;
import net.tracen.umapyoi.container.ContainerRegistry;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.item.data.DataLocation;
import net.tracen.umapyoi.registry.umadata.UmaData;

public class ThreeGoddessContainer
extends AbstractContainerMenu {
    public final ThreeGoddessBlockEntity tileEntity;
    public final ItemStackHandler inventory;
    private final ContainerData containerData;
    private final ContainerLevelAccess canInteractWithCallable;

    public ThreeGoddessContainer(int windowId, Inventory playerInventory, ThreeGoddessBlockEntity tileEntity, ContainerData dataIn) {
        super((MenuType)ContainerRegistry.THREE_GODDESS.get(), windowId);
        this.tileEntity = tileEntity;
        this.inventory = tileEntity.getInventory();
        this.containerData = dataIn;
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)tileEntity.getLevel(), (BlockPos)tileEntity.getBlockPos());
        int startX = 8;
        this.addSlot((Slot)new ThreeGoddessJewelSlot((IItemHandler)this.inventory, 0, 80, 27));
        this.addSlot((Slot)new ThreeGoddessFactorSlot((IItemHandler)this.inventory, 1, 50, 78));
        this.addSlot((Slot)new ThreeGoddessFactorSlot((IItemHandler)this.inventory, 2, 109, 78));
        this.addSlot((Slot)new CommonResultSlot(playerInventory.player, (IItemHandler)this.inventory, 3, 80, 79));
        int startPlayerInvY = 137;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.addSlot(new Slot((Container)playerInventory, 9 + row * 9 + column, startX + column * 18, startPlayerInvY + row * 18));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.addSlot(new Slot((Container)playerInventory, column, startX + column * 18, 195));
        }
        this.addDataSlots(dataIn);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemStack1 = slot.getItem();
            itemStack = itemStack1.copy();
            if (index >= 0 && index <= 3) {
                if (!this.moveItemStackTo(itemStack1, 4, 40, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemStack1, itemStack);
            } else if (index >= 4 && index >= 4 && index < 40 && !this.moveItemStackTo(itemStack1, 0, 3, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemStack1.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemStack1);
        }
        return itemStack;
    }

    private static ThreeGoddessBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof ThreeGoddessBlockEntity) {
            return (ThreeGoddessBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + String.valueOf(tileAtPos));
    }

    public ThreeGoddessContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, ThreeGoddessContainer.getTileEntity(playerInventory, data), (ContainerData)new SimpleContainerData(4));
    }

    public boolean stillValid(Player playerIn) {
        return ThreeGoddessContainer.stillValid((ContainerLevelAccess)this.canInteractWithCallable, (Player)playerIn, (Block)((Block)BlockRegistry.THREE_GODDESS.get()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgressionScaled() {
        int i = this.containerData.get(0);
        return i != 0 ? i * 158 / 200 : 0;
    }

    public static class ThreeGoddessJewelSlot
    extends SlotItemHandler {
        public ThreeGoddessJewelSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(ItemStack stack) {
            if (stack.is((Item)ItemRegistry.BLANK_UMA_SOUL.get())) {
                if (this.getItemHandler().getStackInSlot(1).isEmpty() && this.getItemHandler().getStackInSlot(2).isEmpty()) {
                    return true;
                }
                DataLocation defaultloc = new DataLocation(UmaData.DEFAULT_UMA_ID);
                ResourceLocation name = ((DataLocation)stack.getOrDefault(DataComponentsTypeRegistry.DATA_LOCATION, (Object)defaultloc)).name();
                return !name.equals((Object)((DataLocation)this.getItemHandler().getStackInSlot(1).getOrDefault(DataComponentsTypeRegistry.DATA_LOCATION, (Object)defaultloc)).name()) && !name.equals((Object)((DataLocation)this.getItemHandler().getStackInSlot(2).getOrDefault(DataComponentsTypeRegistry.DATA_LOCATION, (Object)defaultloc)).name());
            }
            return false;
        }

        public int getMaxStackSize(ItemStack stack) {
            return 1;
        }
    }

    public static class ThreeGoddessFactorSlot
    extends SlotItemHandler {
        public ThreeGoddessFactorSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(ItemStack stack) {
            boolean result = stack.is((Item)ItemRegistry.UMA_FACTOR_ITEM.get());
            if (!result) {
                return false;
            }
            boolean factorFlag = false;
            ResourceLocation name = ((DataLocation)stack.get(DataComponentsTypeRegistry.DATA_LOCATION)).name();
            ItemStack soulStack = this.getItemHandler().getStackInSlot(0);
            boolean soulFlag = !soulStack.isEmpty() && ((DataLocation)stack.get(DataComponentsTypeRegistry.DATA_LOCATION)).name().equals((Object)((DataLocation)soulStack.get(DataComponentsTypeRegistry.DATA_LOCATION)).name());
            switch (this.getSlotIndex()) {
                case 1: {
                    factorFlag = !this.getItemHandler().getStackInSlot(2).isEmpty() && name.equals((Object)((DataLocation)this.getItemHandler().getStackInSlot(2).get(DataComponentsTypeRegistry.DATA_LOCATION)).name());
                    break;
                }
                case 2: {
                    factorFlag = !this.getItemHandler().getStackInSlot(1).isEmpty() && name.equals((Object)((DataLocation)this.getItemHandler().getStackInSlot(1).get(DataComponentsTypeRegistry.DATA_LOCATION)).name());
                    break;
                }
            }
            return result && !soulFlag && !factorFlag;
        }
    }
}

