/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.container;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.tracen.umapyoi.block.BlockRegistry;
import net.tracen.umapyoi.container.ContainerRegistry;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.item.SupportCardItem;
import net.tracen.umapyoi.item.UmaSoulItem;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.item.data.GachaRankingData;
import net.tracen.umapyoi.registry.training.SupportContainer;
import net.tracen.umapyoi.utils.GachaRanking;

public class DisassemblyBlockMenu
extends AbstractContainerMenu {
    protected final ResultContainer resultSlots = new ResultContainer();
    protected final Container inputSlots = new SimpleContainer(1){

        public int getContainerSize() {
            return 1;
        }

        public void setChanged() {
            super.setChanged();
            DisassemblyBlockMenu.this.slotsChanged((Container)this);
        }
    };
    protected final ContainerLevelAccess access;
    protected final Player player;

    protected boolean mayPickup(Player pPlayer, boolean pHasStack) {
        return this.hasResult();
    }

    protected boolean hasResult() {
        ItemStack inputSoul = this.inputSlots.getItem(0);
        return inputSoul.getItem() instanceof UmaSoulItem || inputSoul.getItem() instanceof SupportCardItem;
    }

    protected void onTake(Player player, ItemStack resultStack) {
        resultStack.onCraftedBy(player.level(), player, resultStack.getCount());
        this.resultSlots.awardUsedRecipes(player, this.getRelevantItems());
        this.shrinkStackInSlot(0);
        this.access.execute((level, pos) -> player.playSound(SoundEvents.AMETHYST_BLOCK_BREAK, 1.0f, 1.0f));
    }

    private List<ItemStack> getRelevantItems() {
        return List.of(this.inputSlots.getItem(0));
    }

    private void shrinkStackInSlot(int pIndex) {
        ItemStack itemstack = this.inputSlots.getItem(pIndex);
        itemstack.shrink(1);
        this.inputSlots.setItem(pIndex, itemstack);
    }

    protected boolean isValidBlock(BlockState pState) {
        return pState.is((Block)BlockRegistry.DISASSEMBLY_BLOCK.get());
    }

    public DisassemblyBlockMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, ContainerLevelAccess.NULL);
    }

    public DisassemblyBlockMenu(int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess pAccess) {
        this((MenuType)ContainerRegistry.DISASSEMBLY_BLOCK.get(), pContainerId, pPlayerInventory, pAccess);
    }

    public DisassemblyBlockMenu(@Nullable MenuType<?> pType, int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess pAccess) {
        super(pType, pContainerId);
        this.access = pAccess;
        this.player = pPlayerInventory.player;
        this.addSlot(new Slot(this.inputSlots, 0, 44, 59));
        this.addSlot(new Slot((Container)this.resultSlots, 1, 116, 59){

            public boolean mayPlace(ItemStack p_39818_) {
                return false;
            }

            public boolean mayPickup(Player p_39813_) {
                return DisassemblyBlockMenu.this.mayPickup(p_39813_, this.hasItem());
            }

            public void onTake(Player p_150604_, ItemStack p_150605_) {
                DisassemblyBlockMenu.this.onTake(p_150604_, p_150605_);
                p_150604_.onEnchantmentPerformed(p_150605_, 0);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)pPlayerInventory, j + i * 9 + 9, 8 + j * 18, 94 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)pPlayerInventory, k, 8 + k * 18, 152));
        }
    }

    public void createResult() {
        if (!this.hasResult()) {
            this.resultSlots.setItem(0, ItemStack.EMPTY);
        } else {
            this.resultSlots.setItem(0, this.getResultItem());
        }
    }

    private ItemStack getResultItem() {
        ItemStack inputSoul = this.inputSlots.getItem(0).copy();
        boolean isSupport = inputSoul.getItem() instanceof SupportContainer;
        if (!(inputSoul.getItem() instanceof UmaSoulItem) && !isSupport) {
            return ItemStack.EMPTY;
        }
        if (!inputSoul.has(DataComponentsTypeRegistry.GACHA_RANKING)) {
            return ItemStack.EMPTY;
        }
        ItemStack result = ItemStack.EMPTY;
        GachaRanking ranking = ((GachaRankingData)inputSoul.get(DataComponentsTypeRegistry.GACHA_RANKING)).ranking();
        switch (ranking) {
            case SR: {
                result = isSupport ? new ItemStack((ItemLike)ItemRegistry.HORSESHOE_GOLD.get()) : new ItemStack((ItemLike)ItemRegistry.CRYSTAL_GOLD.get());
                break;
            }
            case SSR: {
                result = isSupport ? new ItemStack((ItemLike)ItemRegistry.HORSESHOE_RAINBOW.get()) : new ItemStack((ItemLike)ItemRegistry.CRYSTAL_RAINBOW.get());
                break;
            }
            default: {
                result = isSupport ? new ItemStack((ItemLike)ItemRegistry.HORSESHOE_SILVER.get()) : new ItemStack((ItemLike)ItemRegistry.CRYSTAL_SILVER.get());
            }
        }
        return result;
    }

    public void slotsChanged(Container pInventory) {
        super.slotsChanged(pInventory);
        if (pInventory == this.inputSlots) {
            this.createResult();
        }
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.access.execute((level, pos) -> this.clearContainer(pPlayer, this.inputSlots));
    }

    public boolean stillValid(Player pPlayer) {
        return (Boolean)this.access.evaluate((level, pos) -> !this.isValidBlock(level.getBlockState(pos)) ? false : pPlayer.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0, (Object)true);
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot != null && slot.hasItem()) {
            int i;
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (pIndex == 1) {
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (pIndex != 0 ? pIndex >= 2 && pIndex < 38 && !this.moveItemStackTo(itemstack1, i = 0, 1, false) : !this.moveItemStackTo(itemstack1, 2, 38, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(pPlayer, itemstack1);
        }
        return itemstack;
    }
}

