/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.client.screen;

import cn.mcmod_mmf.mmlib.client.model.SimpleBedrockModel;
import cn.mcmod_mmf.mmlib.utils.ClientUtil;
import com.mojang.blaze3d.platform.Lighting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.model.Model;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.tracen.umapyoi.container.ThreeGoddessContainer;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.item.data.DataLocation;
import net.tracen.umapyoi.registry.umadata.UmaData;
import net.tracen.umapyoi.utils.ClientUtils;
import org.joml.Quaternionf;

public class ThreeGoddessScreen
extends AbstractContainerScreen<ThreeGoddessContainer> {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"umapyoi", (String)"textures/gui/three_goddess.png");

    public ThreeGoddessScreen(ThreeGoddessContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.leftPos = 0;
        this.topPos = 0;
        this.imageWidth = 176;
        this.imageHeight = 220;
    }

    protected void renderBg(GuiGraphics graphic, float partialTicks, int mouseX, int mouseY) {
        graphic.blit(BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.renderModels(graphic);
        int l = ((ThreeGoddessContainer)this.menu).getProgressionScaled();
        graphic.blit(BACKGROUND_TEXTURE, this.leftPos + 9, this.topPos + 112, 0, 220, l + 1, 5);
    }

    protected void renderModels(GuiGraphics graphic) {
        ResourceLocation name;
        ItemStack fatherFactor = ((ThreeGoddessContainer)this.menu).inventory.getStackInSlot(1);
        ItemStack motherFactor = ((ThreeGoddessContainer)this.menu).inventory.getStackInSlot(2);
        Lighting.setupForEntityInInventory();
        if (!fatherFactor.isEmpty()) {
            name = ((DataLocation)fatherFactor.getOrDefault(DataComponentsTypeRegistry.DATA_LOCATION, (Object)new DataLocation(UmaData.DEFAULT_UMA_ID))).name();
            this.renderModel(graphic, this.leftPos + 33, this.topPos + 55, 25, new Quaternionf().rotateXYZ(0.5235988f, -0.7853982f, 0.0f), name);
        }
        if (!motherFactor.isEmpty()) {
            name = ((DataLocation)motherFactor.getOrDefault(DataComponentsTypeRegistry.DATA_LOCATION, (Object)new DataLocation(UmaData.DEFAULT_UMA_ID))).name();
            this.renderModel(graphic, this.leftPos + 142, this.topPos + 55, 25, new Quaternionf().rotateXYZ(0.5235988f, 0.7853982f, 0.0f), name);
        }
        Lighting.setupFor3DItems();
    }

    protected void renderModel(GuiGraphics graphic, int pPosX, int pPosY, int pScale, Quaternionf pQuaternion, ResourceLocation name) {
        if (!ClientUtils.getClientUmaDataRegistry().containsKey(name)) {
            name = UmaData.DEFAULT_UMA_ID;
        }
        SimpleBedrockModel model = new SimpleBedrockModel(ClientUtil.getModelPOJO((ResourceLocation)name));
        ClientUtils.renderModelInInventory(graphic, pPosX, pPosY, pScale, pQuaternion, (Model)model, name);
    }

    public void render(GuiGraphics graphic, int mouseX, int mouseY, float partialTicks) {
        super.render(graphic, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphic, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics graphic, int mouseX, int mouseY) {
        graphic.drawString(this.font, this.title, this.imageWidth / 2 - this.font.width(this.title.getVisualOrderText()) / 2, this.titleLabelY - 3, 0xFFFFFF);
        graphic.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 2, 0x404040, false);
    }
}

