/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.client.renderer.blockentity;

import cn.mcmod_mmf.mmlib.client.model.SimpleBedrockModel;
import cn.mcmod_mmf.mmlib.client.model.bedrock.BedrockPart;
import cn.mcmod_mmf.mmlib.client.model.pojo.BedrockModelPOJO;
import cn.mcmod_mmf.mmlib.utils.ClientUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.tracen.umapyoi.block.BlockRegistry;
import net.tracen.umapyoi.block.UmaStatueBlock;
import net.tracen.umapyoi.block.entity.UmaStatueBlockEntity;
import net.tracen.umapyoi.utils.ClientUtils;
import net.tracen.umapyoi.utils.UmaSoulUtils;

public class UmaStatuesBlockRender
implements BlockEntityRenderer<UmaStatueBlockEntity> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"umapyoi", (String)"textures/model/three_goddesses.png");
    private final SimpleBedrockModel model = new SimpleBedrockModel();

    public UmaStatuesBlockRender(BlockEntityRendererProvider.Context context) {
    }

    public void render(UmaStatueBlockEntity tileEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BlockState blockstate;
        Level world = tileEntity.getLevel();
        boolean flag = world != null;
        BlockState blockState = blockstate = flag ? tileEntity.getBlockState() : ((Block)BlockRegistry.UMA_STATUES.get()).defaultBlockState();
        if (blockstate.getBlock() instanceof UmaStatueBlock) {
            Direction direction = (Direction)tileEntity.getBlockState().getValue((Property)UmaStatueBlock.FACING);
            this.renderModel(tileEntity, direction, poseStack, buffer, combinedLight, combinedOverlay);
        }
    }

    private void renderModel(UmaStatueBlockEntity tileEntity, Direction direction, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BedrockModelPOJO pojo;
        poseStack.pushPose();
        poseStack.translate(0.5, 1.5, 0.5);
        poseStack.mulPose(Axis.YN.rotationDegrees(direction.toYRot()));
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        ItemStack item = tileEntity.getStoredItem();
        BedrockModelPOJO bedrockModelPOJO = pojo = tileEntity.isEmpty() ? ClientUtil.getModelPOJO((ResourceLocation)ClientUtils.UMA_STATUES) : ClientUtil.getModelPOJO((ResourceLocation)UmaSoulUtils.getName(item));
        if (this.model.needRefresh(pojo)) {
            this.model.loadModel(pojo);
        }
        BedrockPart leftArm = this.model.getChild("left_arm") != null ? this.model.getChild("left_arm") : new BedrockPart();
        BedrockPart rightArm = this.model.getChild("right_arm") != null ? this.model.getChild("right_arm") : new BedrockPart();
        leftArm.zRot = ClientUtil.convertRotation((float)-5.0f);
        rightArm.zRot = ClientUtil.convertRotation((float)5.0f);
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)(tileEntity.isEmpty() ? TEXTURE : ClientUtils.getTexture(UmaSoulUtils.getName(item)))));
        this.model.renderToBuffer(poseStack, vertexConsumer, combinedLight, combinedOverlay);
        if (this.model.isEmissive()) {
            VertexConsumer emissiveConsumer = buffer.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)(tileEntity.isEmpty() ? TEXTURE : ClientUtils.getEmissiveTexture(UmaSoulUtils.getName(item)))));
            this.model.renderEmissiveParts(poseStack, emissiveConsumer, combinedLight, combinedOverlay, -1);
        }
        poseStack.popPose();
    }
}

