/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.client.renderer.blockentity;

import cn.mcmod_mmf.mmlib.client.model.SimpleBedrockModel;
import cn.mcmod_mmf.mmlib.client.model.pojo.BedrockModelPOJO;
import cn.mcmod_mmf.mmlib.utils.ClientUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.tracen.umapyoi.block.BlockRegistry;
import net.tracen.umapyoi.block.ThreeGoddessBlock;
import net.tracen.umapyoi.block.entity.ThreeGoddessBlockEntity;
import net.tracen.umapyoi.utils.ClientUtils;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ThreeGoddessBlockRender
implements BlockEntityRenderer<ThreeGoddessBlockEntity> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"umapyoi", (String)"textures/model/three_goddesses.png");
    private final SimpleBedrockModel model = new SimpleBedrockModel();

    public ThreeGoddessBlockRender(BlockEntityRendererProvider.Context context) {
    }

    public void render(ThreeGoddessBlockEntity tileEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BlockState blockstate;
        Level world = tileEntity.getLevel();
        boolean flag = world != null;
        BlockState blockState = blockstate = flag ? tileEntity.getBlockState() : ((ThreeGoddessBlock)((Object)BlockRegistry.THREE_GODDESS.get())).defaultBlockState();
        if (blockstate.getBlock() instanceof ThreeGoddessBlock) {
            Direction direction = (Direction)tileEntity.getBlockState().getValue((Property)ThreeGoddessBlock.FACING);
            this.renderModel(tileEntity, direction, poseStack, buffer, combinedLight, combinedOverlay);
            this.renderAnimation(tileEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        }
    }

    private void renderModel(ThreeGoddessBlockEntity tileEntity, Direction direction, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)TEXTURE));
        poseStack.pushPose();
        poseStack.translate(0.5, 1.5, 0.5);
        poseStack.mulPose(Axis.YN.rotationDegrees(direction.toYRot()));
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        BedrockModelPOJO pojo = ClientUtil.getModelPOJO((ResourceLocation)ClientUtils.THREE_GODDESS);
        if (this.model.needRefresh(pojo)) {
            this.model.loadModel(pojo);
        }
        this.model.renderToBuffer(poseStack, vertexconsumer, combinedLight, combinedOverlay);
        poseStack.popPose();
    }

    private void renderAnimation(ThreeGoddessBlockEntity tileEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ItemStack jewel = tileEntity.getInventory().getStackInSlot(0);
        ItemStack soul = tileEntity.getInventory().getStackInSlot(3);
        if (jewel.isEmpty() && soul.isEmpty()) {
            return;
        }
        BlockPos pPos = tileEntity.getBlockPos();
        this.renderItem(tileEntity, partialTicks, poseStack);
        Minecraft.getInstance().getItemRenderer().renderStatic(soul.isEmpty() ? jewel : soul, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffer, tileEntity.getLevel(), (int)pPos.asLong());
    }

    private void renderItem(ThreeGoddessBlockEntity tileEntity, float partialTicks, PoseStack matrixStackIn) {
        float f = ((float)tileEntity.getAnimationTime() + partialTicks) / 20.0f;
        float f1 = Mth.sin((float)f) * 0.1f + 0.1f;
        matrixStackIn.translate(0.5, (double)f1 + 3.0, 0.5);
        matrixStackIn.mulPose(Axis.YP.rotation(f));
        matrixStackIn.scale(0.6f, 0.6f, 0.6f);
    }
}

