/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.client;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.registry.UmaSkillRegistry;
import net.tracen.umapyoi.registry.skills.UmaSkill;
import net.tracen.umapyoi.utils.UmaSoulUtils;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SkillOverlay
implements LayeredDraw.Layer {
    public static final SkillOverlay INSTANCE = new SkillOverlay();
    private final Minecraft minecraft = Minecraft.getInstance();
    private static final ResourceLocation HUD = ResourceLocation.fromNamespaceAndPath((String)"umapyoi", (String)"textures/gui/skill_hud.png");

    private SkillOverlay() {
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!((Boolean)UmapyoiConfig.OVERLAY_SWITCH.get()).booleanValue()) {
            return;
        }
        int x = guiGraphics.guiWidth() / 2;
        int y = guiGraphics.guiHeight();
        LocalPlayer player = this.minecraft.player;
        if (player.isSpectator()) {
            return;
        }
        if (!UmapyoiAPI.getUmaSoul((LivingEntity)player).isEmpty()) {
            guiGraphics.blit(HUD, x + 102, y - 21, 0.0f, 0.0f, 96, 20, 128, 64);
            this.renderSkill(UmapyoiAPI.getUmaSoul((LivingEntity)player), guiGraphics, x + 102, y - 21);
        }
    }

    private void renderSkill(ItemStack soul, GuiGraphics guiGraphics, int x, int y) {
        UmaSkill skill = (UmaSkill)UmaSkillRegistry.REGISTRY.get(UmaSoulUtils.getSelectedSkill(soul));
        if (skill != null) {
            switch (skill.getType()) {
                case BUFF: {
                    guiGraphics.blit(HUD, x + 3, y + 2, 0.0f, 48.0f, 16, 16, 128, 64);
                    break;
                }
                case HINDER: {
                    guiGraphics.blit(HUD, x + 3, y + 2, 16.0f, 48.0f, 16, 16, 128, 64);
                    break;
                }
                case HEAL: {
                    guiGraphics.blit(HUD, x + 3, y + 2, 32.0f, 48.0f, 16, 16, 128, 64);
                    break;
                }
                case PASSIVE: {
                    guiGraphics.blit(HUD, x + 3, y + 2, 48.0f, 48.0f, 16, 16, 128, 64);
                }
            }
            guiGraphics.drawString(this.minecraft.font, skill.getDescription(), x + 22, y + 6, 7946262);
        } else {
            guiGraphics.blit(HUD, x, y, 0.0f, 20.0f, 96, 20, 128, 64);
        }
    }
}

