/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.block.entity;

import cn.mcmod_mmf.mmlib.block.entity.SyncedBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.tracen.umapyoi.block.entity.BlockEntityRegistry;
import net.tracen.umapyoi.container.TrainingFacilityContainer;
import net.tracen.umapyoi.inventory.CommonItemHandler;
import net.tracen.umapyoi.inventory.TerminalResultHandler;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.item.UmaSoulItem;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.registry.training.SupportContainer;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="umapyoi")
public class TrainingFacilityBlockEntity
extends SyncedBlockEntity
implements MenuProvider {
    public static final int MAX_PROCESS_TIME = 260;
    private final ItemStackHandler inventory = this.createHandler();
    protected final ContainerData tileData;
    private final IItemHandler inputHandler = new CommonItemHandler((IItemHandler)this.inventory, Direction.UP, 7, 0);
    private final IItemHandler outputHandler = new TerminalResultHandler((IItemHandler)this.inventory, 0);
    private int recipeTime;

    public TrainingFacilityBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.TRAINING_FACILITY.get(), pos, state);
        this.tileData = this.createIntArray();
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)BlockEntityRegistry.TRAINING_FACILITY.get(), (be, context) -> {
            if (context == Direction.UP) {
                return be.inputHandler;
            }
            return be.outputHandler;
        });
    }

    public static void workingTick(Level level, BlockPos pos, BlockState state, TrainingFacilityBlockEntity blockEntity) {
        if (level.isClientSide()) {
            return;
        }
        boolean didInventoryChange = false;
        if (blockEntity.canWork()) {
            didInventoryChange = blockEntity.processRecipe();
        } else {
            blockEntity.recipeTime = 0;
        }
        if (didInventoryChange) {
            blockEntity.inventoryChanged();
        }
    }

    private boolean processRecipe() {
        if (this.level == null) {
            return false;
        }
        if (this.level.isClientSide()) {
            return false;
        }
        ++this.recipeTime;
        if (this.recipeTime < 260) {
            return false;
        }
        this.recipeTime = 0;
        ItemStack resultStack = this.getResultItem();
        if (resultStack.isEmpty()) {
            return true;
        }
        this.inventory.setStackInSlot(0, resultStack);
        this.getLevel().playSound(null, this.getBlockPos(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
        for (int i = 1; i < 7; ++i) {
            ItemStack supportItem = this.inventory.getStackInSlot(i);
            Item item2 = supportItem.getItem();
            if (!(item2 instanceof SupportContainer)) continue;
            SupportContainer supports = (SupportContainer)item2;
            if (supports.isConsumable(this.getLevel(), supportItem)) {
                supportItem.shrink(1);
                continue;
            }
            supportItem.hurtAndBreak(1, (ServerLevel)this.getLevel(), null, item -> this.getLevel().playSound(null, this.getBlockPos(), SoundEvents.AMETHYST_CLUSTER_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f));
        }
        return true;
    }

    private ItemStack getResultItem() {
        if (this.level == null) {
            return ItemStack.EMPTY;
        }
        ItemStack result = this.inventory.getStackInSlot(0).copy();
        UmaSoulUtils.downPhysique(result);
        for (int i = 1; i < 7; ++i) {
            ItemStack supportItem = this.inventory.getStackInSlot(i);
            Item item = supportItem.getItem();
            if (!(item instanceof SupportContainer)) continue;
            SupportContainer supports = (SupportContainer)item;
            supports.getSupports(this.getLevel(), supportItem).forEach(support -> support.applySupport(result));
        }
        return result;
    }

    private boolean canWork() {
        return this.hasInput();
    }

    private boolean hasInput() {
        ItemStack input = this.inventory.getStackInSlot(0);
        if (input.getItem() instanceof UmaSoulItem && input.has(DataComponentsTypeRegistry.UMADATA_TRAINING) && UmaSoulUtils.getPhysique(input) > 0) {
            for (int i = 1; i < 7; ++i) {
                SupportContainer supports;
                ItemStack supportItem = this.inventory.getStackInSlot(i);
                Item item = supportItem.getItem();
                if (!(item instanceof SupportContainer) || (supports = (SupportContainer)item).canSupport(this.level, supportItem).test(input)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.create();
        for (int i = 0; i < 7; ++i) {
            drops.add((Object)this.inventory.getStackInSlot(i));
        }
        return drops;
    }

    public void setRemoved() {
        super.setRemoved();
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
        this.recipeTime = compound.getInt("RecipeTime");
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("RecipeTime", this.recipeTime);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
    }

    private CompoundTag writeItems(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        return compound;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.writeItems(new CompoundTag(), registries);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(7){

            protected void onContentsChanged(int slot) {
                TrainingFacilityBlockEntity.this.inventoryChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    if (!stack.is((Item)ItemRegistry.UMA_SOUL.get()) || !stack.has(DataComponentsTypeRegistry.UMADATA_TRAINING)) {
                        return false;
                    }
                    for (int i = 1; i < 7; ++i) {
                        ItemStack other = this.getStackInSlot(i);
                        if (other.isEmpty()) continue;
                        Item item = other.getItem();
                        if (item instanceof SupportContainer) {
                            SupportContainer support = (SupportContainer)item;
                            if (support.canSupport(TrainingFacilityBlockEntity.this.getLevel(), other).test(stack)) continue;
                            return false;
                        }
                        return false;
                    }
                    return true;
                }
                Item other = stack.getItem();
                if (other instanceof SupportContainer) {
                    SupportContainer support = (SupportContainer)other;
                    ItemStack soul = this.getStackInSlot(0);
                    for (int i = 1; i < 7; ++i) {
                        ItemStack other2 = this.getStackInSlot(i);
                        if (!soul.isEmpty() && !support.canSupport(TrainingFacilityBlockEntity.this.getLevel(), stack).test(soul)) {
                            return false;
                        }
                        if (i == slot || other2.isEmpty() || support.canSupport(TrainingFacilityBlockEntity.this.getLevel(), stack).test(other2)) continue;
                        return false;
                    }
                } else {
                    return false;
                }
                return true;
            }
        };
    }

    private ContainerData createIntArray() {
        return new ContainerData(){

            public int get(int index) {
                switch (index) {
                    case 0: {
                        return TrainingFacilityBlockEntity.this.recipeTime;
                    }
                }
                return 0;
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        TrainingFacilityBlockEntity.this.recipeTime = value;
                    }
                }
            }

            public int getCount() {
                return 1;
            }
        };
    }

    public AbstractContainerMenu createMenu(int id, Inventory player, Player entity) {
        return new TrainingFacilityContainer(id, player, this, this.tileData);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.umapyoi.training_facility");
    }
}

