/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tracen.umapyoi.container.UmaSelectMenu;

public class UmaSelectBlock
extends CraftingTableBlock {
    private static final Component CONTAINER_TITLE = Component.translatable((String)"container.umapyoi.umaselect");
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final VoxelShape SHAPE_BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape SHAPE_POST = Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    public static final VoxelShape SHAPE_COMMON = Shapes.or((VoxelShape)SHAPE_BASE, (VoxelShape)SHAPE_POST);
    public static final VoxelShape SHAPE_TOP_PLATE = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final VoxelShape SHAPE_COLLISION = Shapes.or((VoxelShape)SHAPE_COMMON, (VoxelShape)SHAPE_TOP_PLATE);
    public static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)Block.box((double)1.0, (double)10.0, (double)0.0, (double)5.333333, (double)14.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)5.333333, (double)12.0, (double)0.0, (double)9.666667, (double)16.0, (double)16.0), Block.box((double)9.666667, (double)14.0, (double)0.0, (double)14.0, (double)18.0, (double)16.0), SHAPE_COMMON});
    public static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)10.0, (double)1.0, (double)16.0, (double)14.0, (double)5.333333), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)12.0, (double)5.333333, (double)16.0, (double)16.0, (double)9.666667), Block.box((double)0.0, (double)14.0, (double)9.666667, (double)16.0, (double)18.0, (double)14.0), SHAPE_COMMON});
    public static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)Block.box((double)10.666667, (double)10.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)6.333333, (double)12.0, (double)0.0, (double)10.666667, (double)16.0, (double)16.0), Block.box((double)2.0, (double)14.0, (double)0.0, (double)6.333333, (double)18.0, (double)16.0), SHAPE_COMMON});
    public static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)10.0, (double)10.666667, (double)16.0, (double)14.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)12.0, (double)6.333333, (double)16.0, (double)16.0, (double)10.666667), Block.box((double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)18.0, (double)6.333333), SHAPE_COMMON});

    public UmaSelectBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape getOcclusionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return SHAPE_COMMON;
    }

    public boolean useShapeForLightOcclusion(BlockState pState) {
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
        return state;
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_COLLISION;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Direction)pState.getValue((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_COMMON;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
    }

    public MenuProvider getMenuProvider(BlockState pState, Level pLevel, BlockPos pPos) {
        return new SimpleMenuProvider((id, inventory, player) -> new UmaSelectMenu(id, inventory, ContainerLevelAccess.create((Level)pLevel, (BlockPos)pPos)), CONTAINER_TITLE);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu(state.getMenuProvider(level, pos));
        return InteractionResult.CONSUME;
    }
}

