/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.block;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.tracen.umapyoi.block.entity.AbstractPedestalBlockEntity;

public abstract class AbstractPedestalBlock
extends BaseEntityBlock {
    public AbstractPedestalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected InteractionResult interactBEWithoutItem(Level level, BlockPos pos, Player player, boolean empty, ItemStack itemStack) {
        if (empty) {
            return InteractionResult.PASS;
        }
        if (!player.getInventory().add(itemStack)) {
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)itemStack);
        }
        level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.25f, 0.5f);
        return InteractionResult.CONSUME;
    }

    protected ItemInteractionResult interactBEWithItem(ItemStack stack, Level level, BlockPos pos, Player player, InteractionHand hand, AbstractPedestalBlockEntity blockEntity, boolean checkBook) {
        if (stack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (blockEntity.isEmpty()) {
            if (hand == InteractionHand.MAIN_HAND && !player.getOffhandItem().isEmpty() && stack.getItem() instanceof BlockItem) {
                return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
            }
            if (checkBook && stack.is(Items.BOOK)) {
                this.transformOnBook(level, pos);
            } else if (blockEntity.addItem(player.getAbilities().instabuild ? stack.copy() : stack)) {
                level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.BLOCKS, 1.0f, 0.8f);
                return ItemInteractionResult.CONSUME;
            }
            return ItemInteractionResult.FAIL;
        }
        player.displayClientMessage((Component)Component.translatable((String)"umapyoi.uma_pedestal.cannot_add_item"), true);
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    protected void transformOnBook(Level level, BlockPos pos) {
    }
}

