/*
 * Decompiled with CFR 0.152.
 */
package net.fwykrin.tlmteleport;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import net.fwykrin.tlmteleport.ModConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@Mod(value="tlmteleport")
public final class TlmTeleportCompanion {
    private static final ResourceLocation TLM_MAID_ID = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"maid");
    private static final Map<UUID, OriginInfo> ORIGIN = new HashMap<UUID, OriginInfo>();
    private static final Queue<PostPlace> POST_QUEUE = new ArrayDeque<PostPlace>();
    private static final Random RAND = new Random();
    private static final Map<UUID, SameDimFollowJob> SAME_DIM_JOBS = new HashMap<UUID, SameDimFollowJob>();

    public TlmTeleportCompanion(ModContainer container) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfig.SPEC);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private static boolean serverReady() {
        return ServerLifecycleHooks.getCurrentServer() != null;
    }

    private static boolean isTlmMaid(Entity ent) {
        ResourceLocation key = ent.getType().builtInRegistryHolder().key().location();
        if (!"touhou_little_maid".equals(key.getNamespace())) {
            return false;
        }
        String path = key.getPath().toLowerCase(Locale.ROOT);
        if (path.contains("maid")) {
            return true;
        }
        String cn = ent.getClass().getName().toLowerCase(Locale.ROOT);
        return cn.contains("maid");
    }

    private static void dbg(ServerPlayer sp, String msg) {
        if (!((Boolean)ModConfig.DEBUG.get()).booleanValue()) {
            return;
        }
        sp.displayClientMessage((Component)Component.literal((String)"[TLMTP] ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)msg).withStyle(ChatFormatting.YELLOW)), false);
    }

    private static boolean isFollowing(ServerPlayer sp, Entity ent) {
        if (!((Boolean)ModConfig.FOLLOWING_ONLY.get()).booleanValue()) {
            return true;
        }
        if (((Boolean)ModConfig.REQUIRE_LEASH_FOR_FOLLOW.get()).booleanValue() && ent instanceof Mob) {
            Mob mob = (Mob)ent;
            if (!mob.isLeashed()) {
                return false;
            }
            Entity holder = mob.getLeashHolder();
            return holder != null && holder.getUUID().equals(sp.getUUID());
        }
        if (ent instanceof TamableAnimal) {
            TamableAnimal ta = (TamableAnimal)ent;
            return !ta.isInSittingPose();
        }
        if (ent instanceof Mob) {
            Mob mob = (Mob)ent;
            return mob.getNavigation() != null && mob.getNavigation().isInProgress();
        }
        return true;
    }

    private static List<Entity> findOwnedMaidsNear(ServerLevel level, UUID playerId, Vec3 center, int radius) {
        AABB box = AABB.ofSize((Vec3)center, (double)((double)radius * 2.0 + 1.0), (double)((double)radius * 2.0 + 1.0), (double)((double)radius * 2.0 + 1.0));
        return level.getEntitiesOfClass(Entity.class, box, ent -> {
            if (!TlmTeleportCompanion.isTlmMaid(ent)) {
                return false;
            }
            if (ent instanceof OwnableEntity) {
                OwnableEntity own = (OwnableEntity)ent;
                UUID owner = own.getOwnerUUID();
                return owner != null && owner.equals(playerId);
            }
            return false;
        });
    }

    private static void safeTeleportNear(Entity ent, ServerPlayer owner, int offXZ, int offY) {
        ServerLevel lvl = (ServerLevel)ent.level();
        Vec3 p = TlmTeleportCompanion.pickSafeSpawnNear(lvl, owner, offXZ, offY);
        ent.teleportTo(p.x, p.y, p.z);
        if (ent instanceof Mob) {
            Mob m = (Mob)ent;
            m.getNavigation().stop();
        }
    }

    private static BlockPos findSafeStandPos(ServerLevel lvl, BlockPos center, int maxRadius, int maxUp, int maxDown) {
        int minY = lvl.getMinBuildHeight() + 1;
        int maxY = lvl.getMaxBuildHeight() - 2;
        ArrayList<Integer> yOffsets = new ArrayList<Integer>();
        yOffsets.add(0);
        for (int i = 1; i <= Math.max(maxUp, maxDown); ++i) {
            if (i <= maxUp) {
                yOffsets.add(i);
            }
            if (i > maxDown) continue;
            yOffsets.add(-i);
        }
        for (int r = 0; r <= maxRadius; ++r) {
            for (int dx = -r; dx <= r; ++dx) {
                for (int dz = -r; dz <= r; ++dz) {
                    if (Math.max(Math.abs(dx), Math.abs(dz)) != r) continue;
                    Iterator iterator = yOffsets.iterator();
                    while (iterator.hasNext()) {
                        boolean airy;
                        BlockPos pos;
                        BlockPos below;
                        BlockState belowState;
                        int dy = (Integer)iterator.next();
                        int y = center.getY() + dy;
                        if (y < minY || y > maxY || !(belowState = lvl.getBlockState(below = (pos = center.offset(dx, 0, dz).atY(y)).below())).isFaceSturdy((BlockGetter)lvl, below, Direction.UP)) continue;
                        BlockState s0 = lvl.getBlockState(pos);
                        BlockState s1 = lvl.getBlockState(pos.above());
                        if (!s0.getFluidState().isEmpty() || !s1.getFluidState().isEmpty()) continue;
                        boolean bl = airy = !(!s0.isAir() && !s0.getCollisionShape((BlockGetter)lvl, pos).isEmpty() || !s1.isAir() && !s1.getCollisionShape((BlockGetter)lvl, pos.above()).isEmpty());
                        if (!airy) continue;
                        return pos;
                    }
                }
            }
        }
        int clampedY = Math.min(Math.max(center.getY() + 1, minY), maxY);
        return new BlockPos(center.getX(), clampedY, center.getZ());
    }

    private static Vec3 pickSafeSpawnNear(ServerLevel toLevel, ServerPlayer owner, int offXZ, int offY) {
        double ox = owner.getX();
        double oy = owner.getY();
        double oz = owner.getZ();
        double bx = ox + (double)(offXZ == 0 ? 0 : RAND.nextInt(offXZ * 2 + 1) - offXZ);
        double by = oy + (double)(offY == 0 ? 0 : RAND.nextInt(offY * 2 + 1) - offY);
        double bz = oz + (double)(offXZ == 0 ? 0 : RAND.nextInt(offXZ * 2 + 1) - offXZ);
        BlockPos center = BlockPos.containing((double)bx, (double)by, (double)bz);
        BlockPos safe = TlmTeleportCompanion.findSafeStandPos(toLevel, center, 6, 6, 6);
        return Vec3.atCenterOf((Vec3i)safe);
    }

    private static Entity fallbackCloneAcrossDimensions(Entity src, ServerLevel toLevel, ServerPlayer owner) {
        try {
            EntityType type = src.getType();
            Entity fresh = type.create((Level)toLevel);
            if (fresh == null) {
                return null;
            }
            CompoundTag tag = new CompoundTag();
            src.saveWithoutId(tag);
            fresh.load(tag);
            int offXZ = Math.max(0, (Integer)ModConfig.POST_OFFSET_XZ.get());
            int offY = Math.max(0, (Integer)ModConfig.POST_OFFSET_Y.get());
            Vec3 p = TlmTeleportCompanion.pickSafeSpawnNear(toLevel, owner, offXZ, offY);
            fresh.moveTo(p.x, p.y, p.z, src.getYRot(), src.getXRot());
            if (fresh instanceof Mob) {
                Mob m = (Mob)fresh;
                m.setAggressive(false);
                m.setTarget(null);
                m.getNavigation().stop();
            }
            if (!toLevel.addFreshEntity(fresh)) {
                return null;
            }
            src.discard();
            return fresh;
        }
        catch (Throwable t) {
            return null;
        }
    }

    @SubscribeEvent
    public void onTravelToDimension(EntityTravelToDimensionEvent e) {
        try {
            Entity entity = e.getEntity();
            if (!(entity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)entity;
            Level lvl = sp.level();
            if (lvl.isClientSide) {
                return;
            }
            if (!TlmTeleportCompanion.serverReady()) {
                return;
            }
            ORIGIN.put(sp.getUUID(), new OriginInfo(lvl.dimension().location(), sp.position()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onChangedDimension(PlayerEvent.PlayerChangedDimensionEvent e) {
        try {
            Player player = e.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)player;
            if (!TlmTeleportCompanion.serverReady()) {
                return;
            }
            MinecraftServer server = sp.server;
            OriginInfo info = ORIGIN.remove(sp.getUUID());
            if (info == null) {
                return;
            }
            ServerLevel fromLevel = server.getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)info.dimKey));
            ServerLevel toLevel = server.getLevel(e.getTo());
            if (fromLevel == null || toLevel == null) {
                return;
            }
            int radius = (Integer)ModConfig.SEARCH_RADIUS.get();
            int maxCnt = (Integer)ModConfig.MAX_TELEPORT_COUNT.get();
            List<Entity> candidates = TlmTeleportCompanion.findOwnedMaidsNear(fromLevel, sp.getUUID(), info.pos, radius);
            TlmTeleportCompanion.dbg(sp, "candidates=" + candidates.size() + " radius=" + radius);
            int teleported = 0;
            for (Entity maid : candidates) {
                if (teleported >= maxCnt) break;
                if (!maid.isAlive() || !(maid.level() instanceof ServerLevel)) continue;
                if (!TlmTeleportCompanion.isFollowing(sp, maid)) {
                    TlmTeleportCompanion.dbg(sp, "skip: not following");
                    continue;
                }
                try {
                    Level from;
                    if (maid instanceof Mob) {
                        Mob mob = (Mob)maid;
                        if (mob.isLeashed()) {
                            mob.dropLeash(true, true);
                            TlmTeleportCompanion.dbg(sp, "dropped leash");
                        }
                        if (mob.isPassenger()) {
                            mob.stopRiding();
                            TlmTeleportCompanion.dbg(sp, "stopped riding");
                        }
                        mob.setAggressive(false);
                        mob.setTarget(null);
                        mob.getNavigation().stop();
                    }
                    if (!maid.canChangeDimensions(from = maid.level(), (Level)toLevel)) {
                        TlmTeleportCompanion.dbg(sp, "skip: cannotChangeDimensions");
                    } else {
                        DimensionTransition transition = new DimensionTransition(toLevel, maid, DimensionTransition.DO_NOTHING);
                        Entity newEnt = maid.changeDimension(transition);
                        if (newEnt != null) {
                            POST_QUEUE.add(new PostPlace(newEnt.getUUID(), toLevel.dimension().location(), sp.getUUID()));
                            ++teleported;
                            TlmTeleportCompanion.dbg(sp, "queued x-dim maid");
                            continue;
                        }
                        TlmTeleportCompanion.dbg(sp, "changeDimension returned null (after cleanup)");
                    }
                    Entity cloned = TlmTeleportCompanion.fallbackCloneAcrossDimensions(maid, toLevel, sp);
                    if (cloned != null) {
                        POST_QUEUE.add(new PostPlace(cloned.getUUID(), toLevel.dimension().location(), sp.getUUID()));
                        ++teleported;
                        TlmTeleportCompanion.dbg(sp, "fallback clone spawned");
                        continue;
                    }
                    TlmTeleportCompanion.dbg(sp, "fallback failed");
                }
                catch (Throwable throwable) {}
            }
            TlmTeleportCompanion.dbg(sp, "teleported=" + teleported + "/" + maxCnt);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onPlayerTeleportSameDim(EntityTeleportEvent e) {
        try {
            if (!((Boolean)ModConfig.ENABLE_SAME_DIMENSION_FOLLOW.get()).booleanValue()) {
                return;
            }
            Entity entity = e.getEntity();
            if (!(entity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)entity;
            if (sp.level().isClientSide) {
                return;
            }
            if (!TlmTeleportCompanion.serverReady()) {
                return;
            }
            ServerLevel level = (ServerLevel)sp.level();
            Vec3 origin = sp.position();
            Vec3 target = new Vec3(e.getTargetX(), e.getTargetY(), e.getTargetZ());
            SAME_DIM_JOBS.put(sp.getUUID(), new SameDimFollowJob(sp.getUUID(), level.dimension().location(), origin, target, (Integer)ModConfig.SEARCH_RADIUS.get(), (Integer)ModConfig.MAX_TELEPORT_COUNT.get()));
            TlmTeleportCompanion.dbg(sp, "queued same-dim follow job");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post e) {
        Mob mob;
        ServerPlayer owner;
        if (!SAME_DIM_JOBS.isEmpty() && TlmTeleportCompanion.serverReady()) {
            MinecraftServer server = e.getServer();
            if (server == null) {
                SAME_DIM_JOBS.clear();
            } else {
                ArrayList<SameDimFollowJob> jobs = new ArrayList<SameDimFollowJob>(SAME_DIM_JOBS.values());
                SAME_DIM_JOBS.clear();
                for (SameDimFollowJob job : jobs) {
                    ServerLevel lvl = server.getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)job.dim));
                    if (lvl == null || (owner = server.getPlayerList().getPlayer(job.playerId)) == null) continue;
                    int offXZ = Math.max(0, (Integer)ModConfig.POST_OFFSET_XZ.get());
                    int offY = Math.max(0, (Integer)ModConfig.POST_OFFSET_Y.get());
                    List<Entity> candidates = TlmTeleportCompanion.findOwnedMaidsNear(lvl, job.playerId, job.origin, job.radius);
                    TlmTeleportCompanion.dbg(owner, "same-dim candidates=" + candidates.size() + " radius=" + job.radius);
                    int moved = 0;
                    for (Entity maid : candidates) {
                        if (moved >= job.max) break;
                        if (!maid.isAlive()) continue;
                        if (!TlmTeleportCompanion.isFollowing(owner, maid)) {
                            TlmTeleportCompanion.dbg(owner, "same-dim skip: not following");
                            continue;
                        }
                        try {
                            if (maid instanceof Mob) {
                                mob = (Mob)maid;
                                if (mob.isLeashed()) {
                                    mob.dropLeash(true, true);
                                }
                                if (mob.isPassenger()) {
                                    mob.stopRiding();
                                }
                                mob.setAggressive(false);
                                mob.setTarget(null);
                                mob.getNavigation().stop();
                            }
                            BlockPos center = BlockPos.containing((double)(job.target.x + (double)(offXZ == 0 ? 0 : RAND.nextInt(offXZ * 2 + 1) - offXZ)), (double)(job.target.y + (double)(offY == 0 ? 0 : RAND.nextInt(offY * 2 + 1) - offY)), (double)(job.target.z + (double)(offXZ == 0 ? 0 : RAND.nextInt(offXZ * 2 + 1) - offXZ)));
                            BlockPos safe = TlmTeleportCompanion.findSafeStandPos(lvl, center, 6, 6, 6);
                            Vec3 p = Vec3.atCenterOf((Vec3i)safe);
                            maid.teleportTo(p.x, p.y, p.z);
                            if (maid instanceof Mob) {
                                Mob m = (Mob)maid;
                                m.getNavigation().stop();
                            }
                            ++moved;
                        }
                        catch (Throwable center) {}
                    }
                    TlmTeleportCompanion.dbg(owner, "same-dim moved=" + moved + "/" + job.max);
                }
            }
        }
        try {
            PostPlace pp;
            if (POST_QUEUE.isEmpty()) {
                return;
            }
            if (!TlmTeleportCompanion.serverReady()) {
                POST_QUEUE.clear();
                return;
            }
            int limit = Math.min(POST_QUEUE.size(), 32);
            MinecraftServer server = e.getServer();
            if (server == null) {
                POST_QUEUE.clear();
                return;
            }
            for (int i = 0; i < limit && (pp = POST_QUEUE.poll()) != null; ++i) {
                Entity ent;
                ServerLevel toLevel = server.getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)pp.toDim));
                if (toLevel == null || (owner = server.getPlayerList().getPlayer(pp.playerId)) == null || (ent = toLevel.getEntity(pp.entityId)) == null) continue;
                int offXZ = Math.max(0, (Integer)ModConfig.POST_OFFSET_XZ.get());
                int offY = Math.max(0, (Integer)ModConfig.POST_OFFSET_Y.get());
                if (pp.toPosOverride != null) {
                    BlockPos center = BlockPos.containing((Position)pp.toPosOverride);
                    BlockPos safe = TlmTeleportCompanion.findSafeStandPos(toLevel, center, 6, 6, 6);
                    Vec3 p = Vec3.atCenterOf((Vec3i)safe);
                    ent.teleportTo(p.x, p.y, p.z);
                    if (!(ent instanceof Mob)) continue;
                    mob = (Mob)ent;
                    mob.getNavigation().stop();
                    continue;
                }
                TlmTeleportCompanion.safeTeleportNear(ent, owner, offXZ, offY);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static final class OriginInfo {
        final ResourceLocation dimKey;
        final Vec3 pos;

        OriginInfo(ResourceLocation dimKey, Vec3 pos) {
            this.dimKey = dimKey;
            this.pos = pos;
        }
    }

    private static final class PostPlace {
        final UUID entityId;
        final ResourceLocation toDim;
        final UUID playerId;
        final Vec3 toPosOverride;

        PostPlace(UUID entityId, ResourceLocation toDim, UUID playerId) {
            this(entityId, toDim, playerId, null);
        }

        PostPlace(UUID entityId, ResourceLocation toDim, UUID playerId, Vec3 toPosOverride) {
            this.entityId = entityId;
            this.toDim = toDim;
            this.playerId = playerId;
            this.toPosOverride = toPosOverride;
        }
    }

    private static final class SameDimFollowJob {
        final UUID playerId;
        final ResourceLocation dim;
        final Vec3 origin;
        final Vec3 target;
        final int radius;
        final int max;

        SameDimFollowJob(UUID playerId, ResourceLocation dim, Vec3 origin, Vec3 target, int radius, int max) {
            this.playerId = playerId;
            this.dim = dim;
            this.origin = origin;
            this.target = target;
            this.radius = radius;
            this.max = max;
        }
    }
}

