/*
 * Decompiled with CFR 0.152.
 */
package net.fwykrin.tlmteleport;

import net.neoforged.neoforge.common.ModConfigSpec;

public final class ModConfig {
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.BooleanValue DEBUG;
    public static final ModConfigSpec.IntValue SEARCH_RADIUS;
    public static final ModConfigSpec.IntValue MAX_TELEPORT_COUNT;
    public static final ModConfigSpec.IntValue POST_OFFSET_XZ;
    public static final ModConfigSpec.IntValue POST_OFFSET_Y;
    public static final ModConfigSpec.BooleanValue FOLLOWING_ONLY;
    public static final ModConfigSpec.BooleanValue REQUIRE_LEASH_FOR_FOLLOW;
    public static final ModConfigSpec.BooleanValue ENABLE_SAME_DIMENSION_FOLLOW;

    private ModConfig() {
    }

    static {
        ModConfigSpec.Builder b = new ModConfigSpec.Builder();
        b.push("tlmteleport");
        DEBUG = b.comment("Print basic debug when picking candidate maids.").define("debug", false);
        SEARCH_RADIUS = b.comment("Search radius in the origin dimension (blocks)").defineInRange("searchRadius", 5, 4, 128);
        MAX_TELEPORT_COUNT = b.comment("Max maid count to teleport per change").defineInRange("maxTeleportCount", 10, 1, 64);
        POST_OFFSET_XZ = b.comment("Random placement offset on X/Z (\u00b1 blocks)").defineInRange("postOffsetXZ", 2, 0, 8);
        POST_OFFSET_Y = b.comment("Random placement offset on Y (\u00b1 blocks)").defineInRange("postOffsetY", 1, 0, 8);
        FOLLOWING_ONLY = b.comment("Teleport only maids that are in 'following' state (not sitting).").define("followingOnly", true);
        REQUIRE_LEASH_FOR_FOLLOW = b.comment("If true, treat 'following' as 'leashed to the player'. Most reliable.").define("requireLeashedForFollow", false);
        ENABLE_SAME_DIMENSION_FOLLOW = b.comment("Also follow when the player teleports within the same dimension (/tp, chorus, etc.)").define("enableSameDimensionFollow", true);
        b.pop();
        SPEC = b.build();
    }
}

