/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;

public class RenderUtils {
    public static void bindTexture(ResourceLocation texture) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
    }

    public static void setup(ResourceLocation texture, float red, float green, float blue, float alpha) {
        RenderUtils.bindTexture(texture);
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void setup(ResourceLocation texture) {
        RenderUtils.setup(texture, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void setColorRGBA(int color) {
        float a = (float)RenderUtils.alpha(color) / 255.0f;
        float r = (float)RenderUtils.red(color) / 255.0f;
        float g = (float)RenderUtils.green(color) / 255.0f;
        float b = (float)RenderUtils.blue(color) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    public static int alpha(int c) {
        return c >> 24 & 0xFF;
    }

    public static int red(int c) {
        return c >> 16 & 0xFF;
    }

    public static int green(int c) {
        return c >> 8 & 0xFF;
    }

    public static int blue(int c) {
        return c & 0xFF;
    }
}

