/*
 * Decompiled with CFR 0.152.
 */
package gaia.util;

import gaia.config.GaiaConfig;
import gaia.entity.projectile.BombProjectile;
import gaia.entity.projectile.BubbleProjectile;
import gaia.entity.projectile.GaiaSmallFireball;
import gaia.entity.projectile.MagicProjectile;
import gaia.entity.projectile.PoisonProjectile;
import gaia.entity.projectile.RandomMagicProjectile;
import gaia.entity.projectile.WebProjectile;
import gaia.registry.GaiaSounds;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.phys.Vec3;

public class RangedUtil {
    public static void rangedAttack(LivingEntity target, LivingEntity shooter, float distanceFactor) {
        ItemStack arrowStack = shooter.getProjectile(shooter.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)shooter, item -> item instanceof BowItem)));
        RangedUtil.rangedAttack(target, shooter, distanceFactor, arrowStack);
    }

    public static void rangedAttack(LivingEntity target, LivingEntity shooter, float distanceFactor, ItemStack arrowStack) {
        AbstractArrow abstractarrow = RangedUtil.getArrow(shooter, arrowStack, distanceFactor);
        ItemStack heldItem = shooter.getMainHandItem();
        Item item = heldItem.getItem();
        if (item instanceof BowItem) {
            BowItem bowItem = (BowItem)item;
            abstractarrow = bowItem.customArrow(abstractarrow, arrowStack, heldItem);
        }
        double d0 = target.getX() - shooter.getX();
        double d1 = target.getY(0.3333333333333333) - abstractarrow.getY();
        double d2 = target.getZ() - shooter.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - shooter.level().getDifficulty().getId() * 4));
        abstractarrow.setBaseDamage((double)distanceFactor * 2.0 + shooter.getRandom().nextGaussian() * 0.25 + (double)shooter.level().getDifficulty().getId() * 0.11);
        abstractarrow.setOwner((Entity)shooter);
        if (shooter.level().getDifficulty() == Difficulty.HARD && ((Boolean)GaiaConfig.COMMON.baseDamageArchers.get()).booleanValue() && abstractarrow instanceof Arrow) {
            Arrow arrow = (Arrow)abstractarrow;
            arrow.addEffect(new MobEffectInstance(MobEffects.HARM, 1, 0));
        }
        shooter.playSound(SoundEvents.ARROW_SHOOT, 1.0f, 1.0f / (shooter.getRandom().nextFloat() * 0.4f + 0.8f));
        shooter.level().addFreshEntity((Entity)abstractarrow);
    }

    public static AbstractArrow getArrow(LivingEntity shooter, ItemStack arrowStack, float distanceFactor) {
        return ProjectileUtil.getMobArrow((LivingEntity)shooter, (ItemStack)arrowStack, (float)distanceFactor, null);
    }

    public static void fireball(LivingEntity target, LivingEntity shooter, float distanceFactor) {
        shooter.playSound((SoundEvent)GaiaSounds.GAIA_SHOOT.get(), 1.0f, 1.0f / (shooter.getRandom().nextFloat() * 0.4f + 0.8f));
        double d0 = target.getX() - shooter.getX();
        double d1 = target.getY(0.5) - shooter.getY(0.5);
        double d2 = target.getZ() - shooter.getZ();
        double f1 = (double)Mth.sqrt((float)distanceFactor) * 0.5;
        Vec3 vec3 = new Vec3(d0 + shooter.getRandom().nextGaussian() * f1, d1, d2 + shooter.getRandom().nextGaussian() * f1);
        GaiaSmallFireball smallFireball = new GaiaSmallFireball(shooter.level(), shooter.getX(), shooter.getY(), shooter.getZ(), vec3.normalize());
        smallFireball.setPos(smallFireball.getX(), shooter.getY(0.5) + 0.5, smallFireball.getZ());
        smallFireball.setOwner((Entity)shooter);
        shooter.level().addFreshEntity((Entity)smallFireball);
    }

    public static void potion(LivingEntity target, LivingEntity shooter, float distanceFactor, Holder<Potion> potionHolder) {
        Vec3 vec3 = shooter.getDeltaMovement();
        double d0 = target.getY() + (double)target.getEyeHeight() - (double)1.1f;
        double d1 = target.getX() + vec3.x - shooter.getX();
        double d2 = d0 - shooter.getY();
        double d3 = target.getZ() + vec3.z - shooter.getZ();
        float f = Mth.sqrt((float)((float)(d1 * d1 + d3 * d3)));
        ThrownPotion thrownpotion = new ThrownPotion(shooter.level(), shooter);
        ItemStack potionStack = Items.SPLASH_POTION.getDefaultInstance();
        potionStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(potionHolder));
        thrownpotion.setItem(potionStack);
        thrownpotion.setXRot(thrownpotion.getXRot() + 20.0f);
        thrownpotion.shoot(d1, d2 + (double)(f * 0.2f), d3, 0.75f, 8.0f);
        thrownpotion.setOwner((Entity)shooter);
        shooter.level().playSound((Player)null, shooter.getX(), shooter.getY(), shooter.getZ(), SoundEvents.WITCH_THROW, shooter.getSoundSource(), 1.0f, 0.8f + shooter.getRandom().nextFloat() * 0.4f);
        shooter.level().addFreshEntity((Entity)thrownpotion);
    }

    public static void magic(LivingEntity target, LivingEntity shooter, float distanceFactor) {
        shooter.playSound((SoundEvent)GaiaSounds.GAIA_SHOOT.get(), 1.0f, 1.0f / (shooter.getRandom().nextFloat() * 0.4f + 0.8f));
        double d0 = target.getX() - shooter.getX();
        double d1 = target.getY(0.5) - shooter.getY(0.5);
        double d2 = target.getZ() - shooter.getZ();
        double f1 = (double)Mth.sqrt((float)distanceFactor) * 0.5;
        Vec3 vec3 = new Vec3(d0 + shooter.getRandom().nextGaussian() * f1, d1, d2 + shooter.getRandom().nextGaussian() * f1);
        MagicProjectile magic = new MagicProjectile(shooter.level(), shooter.getX(), shooter.getY(), shooter.getZ(), vec3.normalize());
        magic.setPos(magic.getX(), shooter.getY(0.5) + 0.5, magic.getZ());
        magic.setOwner((Entity)shooter);
        shooter.level().addFreshEntity((Entity)magic);
    }

    public static void magicRandom(LivingEntity target, LivingEntity shooter, float distanceFactor, double yOffset, Holder<MobEffect> mobEffect) {
        shooter.playSound((SoundEvent)GaiaSounds.GAIA_SHOOT.get(), 1.0f, 1.0f / (shooter.getRandom().nextFloat() * 0.4f + 0.8f));
        double d0 = target.getX() - shooter.getX();
        double d1 = target.getY(0.5) - shooter.getY(0.5);
        double d2 = target.getZ() - shooter.getZ();
        double f1 = (double)Mth.sqrt((float)distanceFactor) * 0.5;
        Vec3 vec3 = new Vec3(d0 + shooter.getRandom().nextGaussian() * f1, d1, d2 + shooter.getRandom().nextGaussian() * f1);
        RandomMagicProjectile magic = new RandomMagicProjectile(shooter.level(), shooter.getX(), shooter.getY(), shooter.getZ(), vec3.normalize());
        magic.setPos(magic.getX(), shooter.getY(0.5) + 0.5 + yOffset, magic.getZ());
        magic.setEffect(mobEffect);
        magic.setOwner((Entity)shooter);
        shooter.level().addFreshEntity((Entity)magic);
    }

    public static void web(LivingEntity target, LivingEntity shooter, float distanceFactor) {
        shooter.playSound((SoundEvent)GaiaSounds.GAIA_SHOOT.get(), 1.0f, 1.0f / (shooter.getRandom().nextFloat() * 0.4f + 0.8f));
        double d0 = target.getX() - shooter.getX();
        double d1 = target.getY(0.5) - shooter.getY(0.5);
        double d2 = target.getZ() - shooter.getZ();
        double f1 = (double)Mth.sqrt((float)distanceFactor) * 0.5;
        Vec3 vec3 = new Vec3(d0 + shooter.getRandom().nextGaussian() * f1, d1, d2 + shooter.getRandom().nextGaussian() * f1);
        WebProjectile web = new WebProjectile(shooter.level(), shooter.getX(), shooter.getY(), shooter.getZ(), vec3.normalize());
        web.setPos(web.getX(), shooter.getY(0.5) + 0.5, web.getZ());
        web.setOwner((Entity)shooter);
        shooter.level().addFreshEntity((Entity)web);
    }

    public static void bubble(LivingEntity target, LivingEntity shooter, float distanceFactor) {
        shooter.playSound((SoundEvent)GaiaSounds.GAIA_SHOOT.get(), 1.0f, 1.0f / (shooter.getRandom().nextFloat() * 0.4f + 0.8f));
        double d0 = target.getX() - shooter.getX();
        double d1 = target.getY(0.5) - shooter.getY(0.5);
        double d2 = target.getZ() - shooter.getZ();
        double f1 = (double)Mth.sqrt((float)distanceFactor) * 0.5;
        Vec3 vec3 = new Vec3(d0 + shooter.getRandom().nextGaussian() * f1, d1, d2 + shooter.getRandom().nextGaussian() * f1);
        BubbleProjectile bubble = new BubbleProjectile(shooter.level(), shooter.getX(), shooter.getY(), shooter.getZ(), vec3.normalize());
        bubble.setPos(bubble.getX(), shooter.getY(0.5) + 0.5, bubble.getZ());
        bubble.setOwner((Entity)shooter);
        shooter.level().addFreshEntity((Entity)bubble);
    }

    public static void poison(LivingEntity target, LivingEntity shooter, float distanceFactor) {
        shooter.playSound((SoundEvent)GaiaSounds.GAIA_SHOOT.get(), 1.0f, 1.0f / (shooter.getRandom().nextFloat() * 0.4f + 0.8f));
        double d0 = target.getX() - shooter.getX();
        double d1 = target.getY(0.5) - shooter.getY(0.5);
        double d2 = target.getZ() - shooter.getZ();
        double f1 = (double)Mth.sqrt((float)distanceFactor) * 0.5;
        Vec3 vec3 = new Vec3(d0 + shooter.getRandom().nextGaussian() * f1, d1, d2 + shooter.getRandom().nextGaussian() * f1);
        PoisonProjectile poison = new PoisonProjectile(shooter.level(), shooter.getX(), shooter.getY(), shooter.getZ(), vec3.normalize());
        poison.setPos(poison.getX(), shooter.getY(0.5) + 0.5, poison.getZ());
        poison.setOwner((Entity)shooter);
        shooter.level().addFreshEntity((Entity)poison);
    }

    public static void bomb(LivingEntity target, LivingEntity shooter, float distanceFactor) {
        shooter.playSound((SoundEvent)GaiaSounds.GAIA_SHOOT.get(), 1.0f, 1.0f / (shooter.getRandom().nextFloat() * 0.4f + 0.8f));
        BombProjectile bomb = new BombProjectile(shooter.level(), shooter);
        double d0 = target.getEyeY() - (double)1.1f;
        double d1 = target.getX() - shooter.getX();
        double d2 = d0 - bomb.getY();
        double d3 = target.getZ() - shooter.getZ();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        bomb.shoot(d1, d2 + d4, d3, 0.75f, 8.0f);
        bomb.setOwner((Entity)shooter);
        shooter.level().addFreshEntity((Entity)bomb);
    }
}

