/*
 * Decompiled with CFR 0.152.
 */
package gaia.util;

import com.google.common.collect.ImmutableMap;
import gaia.registry.GaiaRegistry;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class GaiaMerchantTrades {
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> MERCHANT_TRADES = GaiaMerchantTrades.toIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new ItemForMerchantToken((ItemLike)GaiaRegistry.GIGA_GEAR.get(), 1, 4, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.TOTEM_FRAGMENT.get(), 1, 4, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.RING_OF_SPEED.get(), 1, 4, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.RING_OF_HASTE.get(), 1, 4, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.RING_OF_JUMP.get(), 1, 4, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.RING_OF_NIGHT.get(), 1, 4, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.BOX_EGG.get(), 1, 4, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.CREEPER_GIRL.getSpawnEgg().get(), 1, 4, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.SLIME_GIRL.getSpawnEgg().get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.ENDER_GIRL.getSpawnEgg().get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.TRADER.getSpawnEgg().get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.BOX_OVERWORLD.get(), 1, 1, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.BOX_NETHER.get(), 1, 1, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.BOX_END.get(), 1, 1, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.BOX_OLD.get(), 1, 4, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.FAN_FIRE.get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.FAN_ICE.get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.WEAPON_BOOK.get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.WEAPON_BOOK_FREEZING.get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.WEAPON_BOOK_NIGHTMARE.get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.WEAPON_BOOK_METAL.get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.WEAPON_BOOK_ENDER.get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.WEAPON_BOOK_HUNGER.get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.WEAPON_BOOK_BATTLE.get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.WEAPON_BOOK_NATURE.get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.WEAPON_BOOK_WITHER.get(), 1, 2, 10, 5), new ItemForMerchantToken((ItemLike)GaiaRegistry.HEAVY_BARBELL.get(), 1, 2, 10, 5)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new MerchantTokenForItem((ItemLike)GaiaRegistry.BOX_IRON.get(), 1, 1, 10, 5), new MerchantTokenForItem((ItemLike)GaiaRegistry.BOX_GOLD.get(), 1, 2, 10, 5), new MerchantTokenForItem((ItemLike)GaiaRegistry.BOX_DIAMOND.get(), 1, 4, 10, 5), new MerchantTokenForItem((ItemLike)GaiaRegistry.BAG_BOOK.get(), 1, 4, 10, 5), new MerchantTokenForItem((ItemLike)GaiaRegistry.BAG_RECORD.get(), 1, 2, 10, 5), new MerchantTokenForItem((ItemLike)GaiaRegistry.BOOK_OF_MEMORY.get(), 1, 4, 10, 5), new MerchantTokenForItem((ItemLike)GaiaRegistry.CHEST_DUNGEON.get(), 1, 2, 10, 5), new MerchantTokenForItem((ItemLike)GaiaRegistry.CHEST_JUNGLE.get(), 1, 2, 10, 5), new MerchantTokenForItem((ItemLike)GaiaRegistry.CHEST_DESERT.get(), 1, 2, 10, 5), new MerchantTokenForItem((ItemLike)GaiaRegistry.BOX_HAT.get(), 1, 4, 10, 5)}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> CREEPER_GIRL_TRADES = GaiaMerchantTrades.toIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new ItemsToItems((ItemLike)Items.GUNPOWDER, 1, (ItemLike)Items.BONE, 2, 10, 5), new ItemsToItems((ItemLike)Items.GUNPOWDER, 1, (ItemLike)Items.ROTTEN_FLESH, 4, 10, 5), new ItemsToItems((ItemLike)Items.GUNPOWDER, 1, (ItemLike)Items.SPIDER_EYE, 1, 10, 5), new ItemsToItems((ItemLike)Items.GUNPOWDER, 1, (ItemLike)Items.STRING, 2, 10, 5)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new ItemsToItems((ItemLike)Items.BONE, 4, (ItemLike)Items.GUNPOWDER, 1, 10, 5), new ItemsToItems((ItemLike)Items.ENDER_PEARL, 1, (ItemLike)Items.GUNPOWDER, 2, 10, 5), new ItemsToItems((ItemLike)Items.ROTTEN_FLESH, 6, (ItemLike)Items.GUNPOWDER, 1, 10, 5), new ItemsToItems((ItemLike)Items.STRING, 4, (ItemLike)Items.GUNPOWDER, 1, 10, 5), new ItemsToItems((ItemLike)Items.SLIME_BALL, 2, (ItemLike)Items.GUNPOWDER, 1, 10, 5), new ItemsToItems((ItemLike)Items.SPIDER_EYE, 2, (ItemLike)Items.GUNPOWDER, 1, 10, 5)}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> SLIME_GIRL_TRADES = GaiaMerchantTrades.toIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new ItemsToItems((ItemLike)Items.SLIME_BALL, 1, (ItemLike)Items.BONE, 2, 10, 5), new ItemsToItems((ItemLike)Items.SLIME_BALL, 1, (ItemLike)Items.ROTTEN_FLESH, 4, 10, 5), new ItemsToItems((ItemLike)Items.SLIME_BALL, 1, (ItemLike)Items.GUNPOWDER, 1, 10, 5), new ItemsToItems((ItemLike)Items.SLIME_BALL, 1, (ItemLike)Items.SPIDER_EYE, 1, 10, 5), new ItemsToItems((ItemLike)Items.SLIME_BALL, 1, (ItemLike)Items.STRING, 2, 10, 5)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new ItemsToItems((ItemLike)Items.BONE, 4, (ItemLike)Items.SLIME_BALL, 1, 10, 5), new ItemsToItems((ItemLike)Items.ENDER_PEARL, 1, (ItemLike)Items.SLIME_BALL, 2, 10, 5), new ItemsToItems((ItemLike)Items.GUNPOWDER, 2, (ItemLike)Items.SLIME_BALL, 1, 10, 5), new ItemsToItems((ItemLike)Items.ROTTEN_FLESH, 6, (ItemLike)Items.SLIME_BALL, 1, 10, 5), new ItemsToItems((ItemLike)Items.STRING, 4, (ItemLike)Items.SLIME_BALL, 1, 10, 5), new ItemsToItems((ItemLike)Items.SPIDER_EYE, 2, (ItemLike)Items.SLIME_BALL, 1, 10, 5)}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> ENDER_GIRL_TRADES = GaiaMerchantTrades.toIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new ItemsToItems((ItemLike)Items.ENDER_PEARL, 1, (ItemLike)Items.BONE, 8, 10, 5), new ItemsToItems((ItemLike)Items.ENDER_PEARL, 1, (ItemLike)Items.ROTTEN_FLESH, 16, 10, 5), new ItemsToItems((ItemLike)Items.ENDER_PEARL, 1, (ItemLike)Items.GUNPOWDER, 4, 10, 5), new ItemsToItems((ItemLike)Items.ENDER_PEARL, 1, (ItemLike)Items.SPIDER_EYE, 4, 10, 5), new ItemsToItems((ItemLike)Items.ENDER_PEARL, 1, (ItemLike)Items.STRING, 8, 10, 5)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new ItemsToItems((ItemLike)Items.BONE, 16, (ItemLike)Items.ENDER_PEARL, 1, 10, 5), new ItemsToItems((ItemLike)Items.GUNPOWDER, 8, (ItemLike)Items.ENDER_PEARL, 1, 10, 5), new ItemsToItems((ItemLike)Items.ROTTEN_FLESH, 24, (ItemLike)Items.ENDER_PEARL, 1, 10, 5), new ItemsToItems((ItemLike)Items.STRING, 16, (ItemLike)Items.ENDER_PEARL, 1, 10, 5), new ItemsToItems((ItemLike)Items.SLIME_BALL, 8, (ItemLike)Items.ENDER_PEARL, 1, 10, 5), new ItemsToItems((ItemLike)Items.SPIDER_EYE, 8, (ItemLike)Items.ENDER_PEARL, 1, 10, 5)}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> HOLSTAURUS_TRADES = GaiaMerchantTrades.toIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new HolstaurusTokenForItem((ItemLike)Items.WHEAT_SEEDS, 8, 1, 10, 5), new HolstaurusTokenForItem((ItemLike)Items.BEETROOT_SEEDS, 8, 1, 10, 5), new HolstaurusTokenForItem((ItemLike)Items.PUMPKIN_SEEDS, 16, 1, 10, 5), new HolstaurusTokenForItem((ItemLike)Items.MELON_SEEDS, 16, 2, 10, 5), new HolstaurusTokenForItem((ItemLike)Items.CAKE, 1, 16, 10, 5), new HolstaurusTokenForItem((ItemLike)Items.PUMPKIN_PIE, 1, 8, 10, 5), new EnchantedItemForEmeralds(Items.IRON_HOE, (ItemLike)GaiaRegistry.HOLSTAURUS_TOKEN.get(), 16, 10, 5)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new ItemForHolstaurusToken((ItemLike)Items.WHEAT, 8, 1, 10, 5), new ItemForHolstaurusToken((ItemLike)Items.PUMPKIN, 2, 1, 10, 5), new ItemForHolstaurusToken((ItemLike)Items.MELON, 1, 2, 10, 5), new ItemForHolstaurusToken((ItemLike)Items.EGG, 8, 1, 10, 5), new ItemForHolstaurusToken((ItemLike)Items.SUGAR, 16, 1, 10, 5)}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> WERESHEEP_TRADES = GaiaMerchantTrades.toIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new WeresheepTokenForItem((ItemLike)Items.WHITE_WOOL, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.ORANGE_WOOL, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.MAGENTA_WOOL, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.LIGHT_BLUE_WOOL, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.YELLOW_WOOL, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.LIME_WOOL, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.PINK_WOOL, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.GRAY_WOOL, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.LIGHT_GRAY_WOOL, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.CYAN_WOOL, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.PURPLE_WOOL, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.BLUE_WOOL, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.BROWN_WOOL, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.GREEN_WOOL, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.RED_WOOL, 1, 1, 10, 5), new WeresheepTokenForItem((ItemLike)Items.BLACK_WOOL, 1, 1, 10, 5)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new ItemForWeresheepToken((ItemLike)Items.WHITE_WOOL, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.ORANGE_WOOL, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.MAGENTA_WOOL, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.LIGHT_BLUE_WOOL, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.YELLOW_WOOL, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.LIME_WOOL, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.PINK_WOOL, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.GRAY_WOOL, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.LIGHT_GRAY_WOOL, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.CYAN_WOOL, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.PURPLE_WOOL, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.BLUE_WOOL, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.BROWN_WOOL, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.GREEN_WOOL, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.RED_WOOL, 1, 4, 10, 5), new ItemForWeresheepToken((ItemLike)Items.BLACK_WOOL, 1, 4, 10, 5)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new ItemForWeresheepToken((ItemLike)Items.STRING, 4, 4, 10, 5)}));

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> toIntMap(ImmutableMap<Integer, VillagerTrades.ItemListing[]> map) {
        return new Int2ObjectOpenHashMap(map);
    }

    static class ItemForMerchantToken
    extends ItemsToItems {
        public ItemForMerchantToken(ItemLike fromItem, int fromCount, int tokenCount, int maxUses, int xp) {
            super(fromItem, fromCount, (ItemLike)GaiaRegistry.TRADER_TOKEN.get(), tokenCount, maxUses, xp);
        }
    }

    static class MerchantTokenForItem
    extends ItemsToItems {
        public MerchantTokenForItem(ItemLike toItem, int toCount, int tokenCount, int maxUses, int xp) {
            super((ItemLike)GaiaRegistry.TRADER_TOKEN.get(), tokenCount, toItem, toCount, maxUses, xp);
        }
    }

    static class ItemsToItems
    implements VillagerTrades.ItemListing {
        private final ItemStack fromItem;
        private final int fromCount;
        private final ItemStack toItem;
        private final int toCount;
        private final int maxUses;
        private final int XP;
        private final float priceMultiplier;

        public ItemsToItems(ItemLike fromItem, int fromCount, ItemLike toItem, int toCount, int maxUses, int xp) {
            this.fromItem = new ItemStack(fromItem);
            this.fromCount = fromCount;
            this.toItem = new ItemStack(toItem);
            this.toCount = toCount;
            this.maxUses = maxUses;
            this.XP = xp;
            this.priceMultiplier = 0.05f;
        }

        @Nullable
        public MerchantOffer getOffer(Entity entity, RandomSource random) {
            return new MerchantOffer(new ItemCost((ItemLike)this.fromItem.getItem(), this.fromCount), new ItemStack((ItemLike)this.toItem.getItem(), this.toCount), this.maxUses, this.XP, this.priceMultiplier);
        }
    }

    static class HolstaurusTokenForItem
    extends ItemsToItems {
        public HolstaurusTokenForItem(ItemLike toItem, int toCount, int tokenCount, int maxUses, int xp) {
            super((ItemLike)GaiaRegistry.TRADER_TOKEN.get(), tokenCount, toItem, toCount, maxUses, xp);
        }
    }

    static class EnchantedItemForEmeralds
    implements VillagerTrades.ItemListing {
        private final ItemStack itemStack;
        private final ItemLike token;
        private final int tokenCost;
        private final int maxUses;
        private final int XP;
        private final float priceMultiplier;

        public EnchantedItemForEmeralds(Item item, ItemLike token, int tokenCost, int maxUses, int xp) {
            this.itemStack = new ItemStack((ItemLike)item);
            this.token = token;
            this.tokenCost = tokenCost;
            this.maxUses = maxUses;
            this.XP = xp;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer getOffer(Entity entity, RandomSource random) {
            int i = 5 + random.nextInt(15);
            ItemStack itemstack = EnchantmentHelper.enchantItem((RandomSource)random, (ItemStack)new ItemStack((ItemLike)this.itemStack.getItem()), (int)i, (RegistryAccess)entity.registryAccess(), Optional.empty());
            int j = Math.min(this.tokenCost + i, 64);
            ItemCost tokenStack = new ItemCost(this.token, j);
            return new MerchantOffer(tokenStack, itemstack, this.maxUses, this.XP, this.priceMultiplier);
        }
    }

    static class ItemForHolstaurusToken
    extends ItemsToItems {
        public ItemForHolstaurusToken(ItemLike fromItem, int fromCount, int tokenCount, int maxUses, int xp) {
            super(fromItem, fromCount, (ItemLike)GaiaRegistry.HOLSTAURUS_TOKEN.get(), tokenCount, maxUses, xp);
        }
    }

    static class WeresheepTokenForItem
    extends ItemsToItems {
        public WeresheepTokenForItem(ItemLike toItem, int toCount, int tokenCount, int maxUses, int xp) {
            super((ItemLike)GaiaRegistry.TRADER_TOKEN.get(), tokenCount, toItem, toCount, maxUses, xp);
        }
    }

    static class ItemForWeresheepToken
    extends ItemsToItems {
        public ItemForWeresheepToken(ItemLike fromItem, int fromCount, int tokenCount, int maxUses, int xp) {
            super(fromItem, fromCount, (ItemLike)GaiaRegistry.WERESHEEP_TOKEN.get(), tokenCount, maxUses, xp);
        }
    }
}

