/*
 * Decompiled with CFR 0.152.
 */
package gaia.registry.helper;

import gaia.item.MerchantSpawnItem;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaSounds;
import gaia.registry.helper.GaiaMobType;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobReg<T extends Mob> {
    protected final String name;
    protected final Supplier<EntityType<? extends T>> entityType;
    protected final GaiaMobType gaiaMobType;
    protected DeferredItem<Item> spawnEgg;
    protected DeferredHolder<SoundEvent, SoundEvent> SAY;
    protected DeferredHolder<SoundEvent, SoundEvent> HURT;
    protected DeferredHolder<SoundEvent, SoundEvent> DEATH;
    protected DeferredHolder<SoundEvent, SoundEvent> STEP;
    protected DeferredHolder<SoundEvent, SoundEvent> ATTACK;
    protected DeferredHolder<SoundEvent, SoundEvent> SAY_MALE;
    protected DeferredHolder<SoundEvent, SoundEvent> HURT_MALE;
    protected DeferredHolder<SoundEvent, SoundEvent> DEATH_MALE;
    protected DeferredHolder<SoundEvent, SoundEvent> STEP_MALE;
    protected DeferredHolder<SoundEvent, SoundEvent> ATTACK_MALE;
    protected boolean hasGenders;

    @NotNull
    public String getName() {
        return this.name;
    }

    public EntityType<? extends T> getEntityType() {
        return this.entityType.get();
    }

    public GaiaMobType getGaiaSoundType() {
        return this.gaiaMobType;
    }

    public DeferredItem<Item> getSpawnEgg() {
        return this.spawnEgg;
    }

    public SoundEvent getSay() {
        return this.SAY == null ? null : (SoundEvent)this.SAY.get();
    }

    public SoundEvent getHurt() {
        return this.HURT == null ? null : (SoundEvent)this.HURT.get();
    }

    public SoundEvent getDeath() {
        return this.DEATH == null ? null : (SoundEvent)this.DEATH.get();
    }

    public SoundEvent getStep() {
        return this.STEP == null ? null : (SoundEvent)this.STEP.get();
    }

    public SoundEvent getAttack() {
        return this.ATTACK == null ? null : (SoundEvent)this.ATTACK.get();
    }

    public boolean hasGender() {
        return this.hasGenders;
    }

    @Nullable
    public SoundEvent getMaleSay() {
        return this.SAY_MALE == null ? null : (SoundEvent)this.SAY_MALE.get();
    }

    @Nullable
    public SoundEvent getMaleHurt() {
        return this.HURT_MALE == null ? null : (SoundEvent)this.HURT_MALE.get();
    }

    @Nullable
    public SoundEvent getMaleDeath() {
        return this.DEATH_MALE == null ? null : (SoundEvent)this.DEATH_MALE.get();
    }

    @Nullable
    public SoundEvent getMaleStep() {
        return this.STEP_MALE == null ? null : (SoundEvent)this.STEP_MALE.get();
    }

    @Nullable
    public SoundEvent getMaleAttack() {
        return this.ATTACK_MALE == null ? null : (SoundEvent)this.ATTACK_MALE.get();
    }

    public MobReg(String name, EntityType.Builder<T> builder, GaiaMobType mobType, int backgroundColor, int highlightColor, boolean say, boolean hurt, boolean death, boolean step, boolean attack, boolean hasGenders, boolean noSpawnEgg, boolean traderEgg) {
        this.name = name;
        this.entityType = GaiaRegistry.ENTITIES.register(name, () -> builder.build(name));
        this.gaiaMobType = mobType;
        if (!noSpawnEgg) {
            this.spawnEgg = traderEgg ? GaiaRegistry.ITEMS.register("spawn_" + name, () -> new MerchantSpawnItem(this.entityType, new Item.Properties())) : GaiaRegistry.ITEMS.register(name + "_spawn_egg", () -> new DeferredSpawnEggItem(this.entityType, backgroundColor, highlightColor, new Item.Properties()));
        }
        this.SAY = say ? GaiaSounds.SOUND_EVENTS.register(name + "_say", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)(name + "_say")))) : null;
        this.HURT = hurt ? GaiaSounds.SOUND_EVENTS.register(name + "_hurt", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)(name + "_hurt")))) : null;
        this.DEATH = death ? GaiaSounds.SOUND_EVENTS.register(name + "_death", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)(name + "_death")))) : null;
        this.STEP = step ? GaiaSounds.SOUND_EVENTS.register(name + "_step", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)(name + "_step")))) : null;
        DeferredHolder<SoundEvent, SoundEvent> deferredHolder = this.ATTACK = attack ? GaiaSounds.SOUND_EVENTS.register(name + "_attack", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)(name + "_attack")))) : null;
        if (hasGenders) {
            this.SAY_MALE = say ? GaiaSounds.SOUND_EVENTS.register(name + "_male_say", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)(name + "_male_say")))) : null;
            this.HURT_MALE = hurt ? GaiaSounds.SOUND_EVENTS.register(name + "_male_hurt", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)(name + "_male_hurt")))) : null;
            this.DEATH_MALE = death ? GaiaSounds.SOUND_EVENTS.register(name + "_male_death", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)(name + "_male_death")))) : null;
            this.STEP_MALE = step ? GaiaSounds.SOUND_EVENTS.register(name + "_male_step", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)(name + "_male_step")))) : null;
            this.ATTACK_MALE = attack ? GaiaSounds.SOUND_EVENTS.register(name + "_male_attack", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)(name + "_male_attack")))) : null;
        }
        this.hasGenders = hasGenders;
    }

    public static class Builder<T extends Mob> {
        private final String name;
        private final EntityType.Builder<T> builder;
        private final GaiaMobType gaiaMobType;
        private final int backgroundColor;
        private final int highlightColor;
        private boolean say;
        private boolean hurt;
        private boolean death;
        private boolean step;
        private boolean attack;
        private boolean hasGenders;
        private boolean noSpawnEgg;
        private boolean traderEgg;

        public Builder(String name, EntityType.Builder<T> builder, int backgroundColor, int highlightColor) {
            this.name = name;
            this.builder = builder;
            this.gaiaMobType = GaiaMobType.AGGRESSIVE;
            this.backgroundColor = backgroundColor;
            this.highlightColor = highlightColor;
        }

        public Builder(String name, EntityType.Builder<T> builder) {
            this.name = name;
            this.builder = builder;
            this.gaiaMobType = GaiaMobType.AGGRESSIVE;
            this.backgroundColor = 0;
            this.highlightColor = 0;
        }

        public Builder(String name, GaiaMobType mobType, EntityType.Builder<T> builder, int backgroundColor, int highlightColor) {
            this.name = name;
            this.builder = builder;
            this.gaiaMobType = mobType;
            this.backgroundColor = backgroundColor;
            this.highlightColor = highlightColor;
        }

        public Builder(String name, GaiaMobType mobType, EntityType.Builder<T> builder) {
            this.name = name;
            this.builder = builder;
            this.gaiaMobType = mobType;
            this.backgroundColor = 0;
            this.highlightColor = 0;
        }

        public Builder<T> withDefaultSounds() {
            this.say = true;
            this.hurt = true;
            this.death = true;
            return this;
        }

        public Builder<T> noSpawnEgg() {
            this.noSpawnEgg = true;
            return this;
        }

        public Builder<T> traderEgg() {
            this.traderEgg = true;
            return this;
        }

        public Builder<T> withSay() {
            this.say = true;
            return this;
        }

        public Builder<T> withHurt() {
            this.hurt = true;
            return this;
        }

        public Builder<T> withDeath() {
            this.death = true;
            return this;
        }

        public Builder<T> withGender() {
            this.hasGenders = true;
            return this;
        }

        public Builder<T> withStep() {
            this.step = true;
            return this;
        }

        public Builder<T> withAttack() {
            this.attack = true;
            return this;
        }

        public MobReg<T> build() {
            return new MobReg<T>(this.name, this.builder, this.gaiaMobType, this.backgroundColor, this.highlightColor, this.say, this.hurt, this.death, this.step, this.attack, this.hasGenders, this.noSpawnEgg, this.traderEgg);
        }
    }
}

