/*
 * Decompiled with CFR 0.152.
 */
package gaia.item.weapon.book;

import gaia.item.weapon.book.WeaponBookItem;
import gaia.registry.GaiaSounds;
import gaia.util.RandomUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;

public class WitherBookItem
extends WeaponBookItem {
    public WitherBookItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, list, flag);
        Player player = RandomUtil.getPlayer();
        if (player == null) {
            return;
        }
        if (player.getOffhandItem() == stack) {
            list.add((Component)Component.translatable((String)"text.grimoireofgaia.bless.off_hand").withStyle(ChatFormatting.YELLOW));
        } else {
            list.add((Component)Component.translatable((String)"text.grimoireofgaia.bless.main_hand").withStyle(ChatFormatting.YELLOW));
        }
        list.add((Component)Component.translatable((String)((MobEffect)MobEffects.WITHER.value()).getDescriptionId()).append(" II (0:04)"));
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        super.hurtEnemy(stack, target, attacker);
        attacker.level().playSound((Player)null, attacker.getX(), attacker.getY(), attacker.getZ(), (SoundEvent)GaiaSounds.BOOK_HIT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        target.addEffect(new MobEffectInstance(MobEffects.WITHER, 80, 1));
        return true;
    }
}

