/*
 * Decompiled with CFR 0.152.
 */
package gaia.item.weapon;

import gaia.registry.GaiaRegistry;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class SummonStaffItem
extends Item {
    private final Supplier<EntityType<? extends Mob>> typeSupplier;
    private final Supplier<Ingredient> repairIngredient;

    public SummonStaffItem(Item.Properties properties, Supplier<EntityType<? extends Mob>> typeSupplier, @NotNull Supplier<Ingredient> repairIngredient) {
        super(properties);
        this.typeSupplier = typeSupplier;
        this.repairIngredient = repairIngredient;
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairStack) {
        return this.repairIngredient.get().test(repairStack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeLeft) {
        super.releaseUsing(stack, level, livingEntity, timeLeft);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            stack.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            if (!level.isClientSide) {
                BlockPos spawnPos = BlockPos.containing((Position)player.getEyePosition()).relative(player.getDirection());
                Mob summon = (Mob)this.typeSupplier.get().create(level);
                summon.moveTo(spawnPos, 0.0f, 0.0f);
                EventHooks.finalizeMobSpawn((Mob)summon, (ServerLevelAccessor)((ServerLevel)level), (DifficultyInstance)level.getCurrentDifficultyAt(spawnPos), (MobSpawnType)MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null);
                summon.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)GaiaRegistry.HEADGEAR_BOLT.get()));
                summon.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
                summon.setDropChance(EquipmentSlot.OFFHAND, 0.0f);
                summon.setDropChance(EquipmentSlot.FEET, 0.0f);
                summon.setDropChance(EquipmentSlot.LEGS, 0.0f);
                summon.setDropChance(EquipmentSlot.CHEST, 0.0f);
                summon.setDropChance(EquipmentSlot.HEAD, 0.0f);
                CompoundTag tag = summon.getPersistentData();
                tag.putBoolean("grimoireofgaia_staff_summoned", true);
                tag.putUUID("grimoireofgaia_staff_summoner", livingEntity.getUUID());
                summon.targetSelector.getAvailableGoals().removeIf(goal -> goal.getGoal() instanceof NearestAttackableTargetGoal);
                summon.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal(summon, Monster.class, true, living -> {
                    NeutralMob neutralMob;
                    return !tag.contains("grimoireofgaia_staff_summoned") && (living instanceof Monster && !(living instanceof NeutralMob) || living instanceof NeutralMob && (neutralMob = (NeutralMob)living).getPersistentAngerTarget().equals(livingEntity.getUUID()));
                }));
                level.addFreshEntity((Entity)summon);
            }
            player.playSound(SoundEvents.CHICKEN_EGG, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
        } else {
            stack.shrink(1);
        }
        return super.finishUsingItem(stack, level, livingEntity);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.getItemInHand(interactionHand);
        player.startUsingItem(interactionHand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, list, flag);
        list.add((Component)Component.translatable((String)"text.grimoireofgaia.summoning_staff.desc", (Object[])new Object[]{Component.translatable((String)this.typeSupplier.get().getDescriptionId()).getString()}).withStyle(ChatFormatting.GRAY));
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        return 30;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment != Enchantments.MENDING && super.isPrimaryItemFor(stack, enchantment);
    }
}

