/*
 * Decompiled with CFR 0.152.
 */
package gaia.item.shield;

import java.util.function.Supplier;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class TieredShieldItem
extends ShieldItem {
    private final LazyLoadedValue<Ingredient> repairIngredient;

    public TieredShieldItem(Item.Properties properties, Supplier<Ingredient> ingredientSupplier) {
        super(properties);
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)ArmorItem.DISPENSE_ITEM_BEHAVIOR);
        this.repairIngredient = new LazyLoadedValue(ingredientSupplier);
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return ((Ingredient)this.repairIngredient.get()).test(repair) || super.isValidRepairItem(toRepair, repair);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility ItemAbility2) {
        return ItemAbilities.DEFAULT_SHIELD_ACTIONS.contains(ItemAbility2);
    }
}

