/*
 * Decompiled with CFR 0.152.
 */
package gaia.item.fuel;

import gaia.item.fuel.FuelItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class SoulfireItem
extends FuelItem {
    public SoulfireItem(Item.Properties properties) {
        super(properties, 11600);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockpos;
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockState blockstate = level.getBlockState(blockpos = context.getClickedPos());
        if (!(CampfireBlock.canLight((BlockState)blockstate) || CandleBlock.canLight((BlockState)blockstate) || CandleCakeBlock.canLight((BlockState)blockstate))) {
            BlockPos relativePos = blockpos.relative(context.getClickedFace());
            if (BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)relativePos, (Direction)context.getHorizontalDirection())) {
                level.playSound(player, relativePos, SoundEvents.GHAST_SCREAM, SoundSource.PLAYERS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
                BlockState relativeState = BaseFireBlock.getState((BlockGetter)level, (BlockPos)relativePos);
                level.setBlock(relativePos, relativeState, 11);
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, blockpos);
                ItemStack stack = context.getItemInHand();
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, relativePos, stack);
                    stack.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)context.getHand()));
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
            return InteractionResult.FAIL;
        }
        level.playSound(player, blockpos, SoundEvents.GHAST_SCREAM, SoundSource.PLAYERS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
        level.setBlock(blockpos, (BlockState)blockstate.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.TRUE), 11);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, blockpos);
        if (player != null) {
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)context.getHand()));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, list, flag);
        list.add((Component)Component.translatable((String)"text.grimoireofgaia.soulfire.desc").withStyle(ChatFormatting.ITALIC));
    }
}

