/*
 * Decompiled with CFR 0.152.
 */
package gaia.item.edible;

import gaia.config.GaiaConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class EdibleEffectItem
extends Item {
    public EdibleEffectItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, list, flag);
        FoodProperties foodProperties = stack.getFoodProperties(null);
        if (foodProperties != null && !GaiaConfig.CLIENT.hideFoodEffectTooltips.getAsBoolean()) {
            for (FoodProperties.PossibleEffect possibleEffect : foodProperties.effects()) {
                MobEffectInstance effect = possibleEffect.effect();
                int totalSeconds = effect.getDuration() / 20;
                int minutes = totalSeconds % 3600 / 60;
                int seconds = totalSeconds % 60;
                list.add((Component)Component.translatable((String)effect.getDescriptionId()).append((Component)Component.literal((String)String.format(" (%d:%02d)", minutes, seconds))).withStyle(ChatFormatting.GRAY));
            }
        }
    }

    protected void rewardEXP(Player player, int value) {
        Level level = player.level();
        ExperienceOrb orb = new ExperienceOrb(level, player.getX(), player.getY() + 1.0, player.getZ(), value);
        if (!level.isClientSide) {
            level.addFreshEntity((Entity)orb);
        }
    }
}

