/*
 * Decompiled with CFR 0.152.
 */
package gaia.item.accessory;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.fml.ModList;

public abstract class AbstractAccessoryItem
extends Item {
    public AbstractAccessoryItem(Item.Properties properties) {
        super(properties.rarity(Rarity.RARE));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, list, flag);
    }

    public boolean isFoil(ItemStack stack) {
        return ModList.get().isLoaded("curios");
    }

    public boolean isModifier() {
        return false;
    }

    public abstract void doEffect(LivingEntity var1, ItemStack var2);

    public abstract void applyModifier(LivingEntity var1, ItemStack var2);

    public abstract void removeModifier(LivingEntity var1, ItemStack var2);

    public void onEquip(LivingEntity livingEntity, ItemStack stack) {
        if (this.isModifier()) {
            this.applyModifier(livingEntity, stack);
        }
    }

    public void onUnequip(LivingEntity livingEntity, ItemStack stack) {
        if (this.isModifier()) {
            this.removeModifier(livingEntity, stack);
        }
    }

    public void onTick(LivingEntity livingEntity, ItemStack stack) {
        this.doEffect(livingEntity, stack);
    }
}

