/*
 * Decompiled with CFR 0.152.
 */
package gaia.item;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class LootableItem
extends Item {
    private final ResourceKey<LootTable> lootTable;
    private final Supplier<SoundEvent> openSoundSupplier;

    public LootableItem(Item.Properties properties, ResourceKey<LootTable> lootTable, Supplier<SoundEvent> openSoundSupplier) {
        super(properties);
        this.lootTable = lootTable;
        this.openSoundSupplier = openSoundSupplier;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        player.playSound(this.openSoundSupplier.get(), 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
        if (!level.isClientSide) {
            LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(this.lootTable);
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)player.position());
            if (player != null) {
                builder.withLuck(player.getLuck());
            }
            ObjectArrayList lootStacks = lootTable.getRandomItems(builder.create(LootContextParamSets.CHEST));
            for (ItemStack lootStack : lootStacks) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)lootStack);
            }
        }
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, list, flag);
        list.add((Component)Component.translatable((String)"text.grimoireofgaia.right_click_use"));
    }
}

