/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.prop;

import gaia.entity.Mimic;
import gaia.entity.prop.AbstractPropEntity;
import gaia.registry.GaiaLootTables;
import gaia.registry.GaiaRegistry;
import gaia.util.LootHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class Chest
extends AbstractPropEntity {
    private static final EntityDataAccessor<Integer> ROTATION = SynchedEntityData.defineId(Chest.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DROP = SynchedEntityData.defineId(Chest.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public Chest(EntityType<? extends AgeableMob> type, Level level) {
        super(type, level);
        this.xpReward = 0;
        this.yBodyRotO = 180.0f;
        this.yBodyRot = 180.0f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 1.0);
    }

    public void knockback(double strength, double xRatio, double zRatio) {
    }

    public void aiStep() {
        if (this.playerDetection() && this.getDrop() == 2) {
            if (!this.level().isClientSide) {
                this.spawnMimic();
            }
            this.discard();
        }
        super.aiStep();
    }

    private void spawnMimic() {
        Mimic mimic;
        if (this.level().getDifficulty() != Difficulty.PEACEFUL && (mimic = (Mimic)GaiaRegistry.MIMIC.getEntityType().create(this.level())) != null) {
            mimic.moveTo(this.blockPosition(), 0.0f, 0.0f);
            mimic.finalizeSpawn((ServerLevelAccessor)((ServerLevel)this.level()), this.level().getCurrentDifficultyAt(this.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
            this.level().addFreshEntity((Entity)mimic);
        }
        this.level().broadcastEntityEvent((Entity)this, (byte)6);
    }

    private boolean playerDetection() {
        AABB aabb = new AABB(this.getX(), this.getY(), this.getZ(), this.getX() + 1.0, this.getY() + 1.0, this.getZ() + 1.0).inflate(4.0);
        List list = this.level().getEntitiesOfClass(Player.class, aabb);
        return !list.isEmpty();
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        this.hurt(this.damageSources().generic(), 2.0f);
        return super.mobInteract(player, hand);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        data = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, data);
        this.yBodyRot = 180.0f;
        this.yBodyRotO = 180.0f;
        this.setYRot(180.0f);
        this.yRotO = 180.0f;
        this.yHeadRot = 180.0f;
        this.yHeadRotO = 180.0f;
        RandomSource random = levelAccessor.getRandom();
        switch (random.nextInt(4)) {
            case 0: {
                this.setRotation(0);
                break;
            }
            case 1: {
                this.setRotation(1);
                break;
            }
            case 2: {
                this.setRotation(2);
                break;
            }
            case 3: {
                this.setRotation(3);
            }
        }
        if (random.nextInt(2) == 0) {
            if (random.nextInt(2) == 0) {
                this.setDrop(2);
            } else {
                this.setDrop(1);
            }
        } else {
            this.setDrop(0);
        }
        return data;
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ROTATION, (Object)0);
        builder.define(DROP, (Object)0);
    }

    public int getRotation() {
        return (Integer)this.entityData.get(ROTATION);
    }

    public void setRotation(int rotation) {
        this.entityData.set(ROTATION, (Object)rotation);
    }

    public int getDrop() {
        return (Integer)this.entityData.get(DROP);
    }

    public void setDrop(int drop) {
        this.entityData.set(DROP, (Object)drop);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putByte("rotation", (byte)this.getRotation());
        tag.putByte("drop", (byte)this.getDrop());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("rotation")) {
            this.setRotation(tag.getByte("rotation"));
        }
        if (tag.contains("drop")) {
            this.setDrop(tag.getByte("drop"));
        }
    }

    protected void playParticleEffect(boolean smoke) {
        SimpleParticleType particle = ParticleTypes.SMOKE;
        if (!smoke) {
            particle = ParticleTypes.POOF;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)particle, this.getX() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), this.getY() + 0.5 + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), d0, d1, d2);
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 7) {
            this.playParticleEffect(true);
        } else if (id == 6) {
            this.playParticleEffect(false);
        } else {
            super.handleEntityEvent(id);
        }
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.CHEST_CLOSE;
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        if (this.getDrop() == 2) {
            return null;
        }
        if (this.getDrop() == 1) {
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
            this.spawnMimic();
            return null;
        }
        return super.getDefaultLootTable();
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource damageSource, boolean killedByPlayer) {
        if (!this.level().isClientSide) {
            LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)damageSource).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)damageSource.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)damageSource.getDirectEntity());
            if (killedByPlayer && this.lastHurtByPlayer != null) {
                lootcontext$builder = lootcontext$builder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)this.lastHurtByPlayer).withLuck(this.lastHurtByPlayer.getLuck());
            }
            List<ItemStack> stacks = LootHelper.getStacksFromTable((ServerLevel)this.level(), lootcontext$builder, LootContextParamSets.ENTITY, GaiaLootTables.CHEST_TABLES, 2);
            stacks.forEach(arg_0 -> ((Chest)this).spawnAtLocation(arg_0));
        }
        super.dropCustomDeathLoot(serverLevel, damageSource, killedByPlayer);
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        return false;
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public int getMaxHeadXRot() {
        return 180;
    }

    public int getMaxHeadYRot() {
        return 180;
    }

    public void push(Entity entity) {
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public float getPickRadius() {
        return 0.0f;
    }

    public static boolean checkChestSpawnRules(EntityType<? extends AgeableMob> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Chest.checkDaysPassed(levelAccessor) && Chest.checkBelowSeaLevel(levelAccessor, pos) && Chest.checkPropSpawnRules(entityType, levelAccessor, spawnType, pos, random);
    }
}

