/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.prop;

import gaia.entity.AntWorker;
import gaia.entity.prop.AbstractPropEntity;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaSounds;
import gaia.util.SharedEntityData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.Nullable;

public class AntHill
extends AbstractPropEntity {
    private static final EntityDataAccessor<Integer> DETECTION = SynchedEntityData.defineId(AntHill.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SPAWN_AMOUNT = SynchedEntityData.defineId(AntHill.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int spawnTime = 0;

    public AntHill(EntityType<? extends AgeableMob> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    @Override
    public void finalizeAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)SharedEntityData.getMaxHealth1());
    }

    public boolean hurt(DamageSource source, float damage) {
        float input = source.is(DamageTypes.FELL_OUT_OF_WORLD) ? damage : Math.min(damage, SharedEntityData.getBaseDefense1());
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack itemstack = player.getItemInHand(player.getUsedItemHand());
            input = itemstack.canPerformAction(ItemAbilities.SHOVEL_DIG) ? (input *= 8.0f) : 0.0f;
        }
        return super.hurt(source, input);
    }

    public void knockback(double strength, double xRatio, double zRatio) {
    }

    public void aiStep() {
        if (this.playerDetection()) {
            if (this.getSpawnAmount() > 0) {
                if (this.spawnTime >= 0 && this.spawnTime <= 60) {
                    ++this.spawnTime;
                } else {
                    if (!this.level().isClientSide) {
                        this.setSpawn(0);
                    }
                    this.hurt(this.damageSources().generic(), this.getMaxHealth() / (float)this.getSpawnAmount());
                    this.setSpawnAmount(this.getSpawnAmount() - 1);
                    this.spawnTime = 0;
                }
            } else {
                this.kill();
            }
        }
        if (this.level().getDifficulty() == Difficulty.PEACEFUL) {
            this.kill();
        }
        super.aiStep();
    }

    private void setSpawn(int id) {
        AntWorker antWorker;
        if (this.level().getDifficulty() != Difficulty.PEACEFUL && id == 0 && (antWorker = (AntWorker)GaiaRegistry.ANT_WORKER.getEntityType().create(this.level())) != null) {
            antWorker.moveTo(this.blockPosition(), 0.0f, 0.0f);
            antWorker.finalizeSpawn((ServerLevelAccessor)((ServerLevel)this.level()), this.level().getCurrentDifficultyAt(this.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
            this.level().addFreshEntity((Entity)antWorker);
        }
        this.level().broadcastEntityEvent((Entity)this, (byte)6);
    }

    private boolean playerDetection() {
        AABB aabb = new AABB(this.getX(), this.getY(), this.getZ(), this.getX() + 1.0, this.getY() + 1.0, this.getZ() + 1.0).inflate((double)this.getDetection());
        List list = this.level().getEntitiesOfClass(Player.class, aabb);
        return !list.isEmpty();
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        data = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, data);
        this.yBodyRot = 180.0f;
        this.yBodyRotO = 180.0f;
        this.setYRot(180.0f);
        this.yRotO = 180.0f;
        this.yHeadRot = 180.0f;
        this.yHeadRotO = 180.0f;
        if (this.random.nextInt(2) == 0) {
            this.setDetection(8);
            this.setSpawnAmount(4);
        } else {
            this.setDetection(6);
            this.setSpawnAmount(2);
        }
        return data;
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DETECTION, (Object)-1);
        builder.define(SPAWN_AMOUNT, (Object)-1);
    }

    public int getDetection() {
        return (Integer)this.entityData.get(DETECTION);
    }

    private void setDetection(int value) {
        this.entityData.set(DETECTION, (Object)value);
    }

    public int getSpawnAmount() {
        return (Integer)this.entityData.get(SPAWN_AMOUNT);
    }

    private void setSpawnAmount(int value) {
        this.entityData.set(SPAWN_AMOUNT, (Object)value);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Detection", this.getDetection());
        tag.putInt("SpawnAmount", this.getSpawnAmount());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Detection")) {
            this.setDetection(tag.getInt("Detection"));
        }
        if (tag.contains("SpawnAmount")) {
            this.setSpawnAmount(tag.getInt("SpawnAmount"));
        }
    }

    protected void playParticleEffect(boolean smoke) {
        SimpleParticleType particle = ParticleTypes.SMOKE;
        if (!smoke) {
            particle = ParticleTypes.POOF;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)particle, this.getX() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), this.getY() + 0.5 + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), d0, d1, d2);
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 7) {
            this.playParticleEffect(true);
        } else if (id == 6) {
            this.playParticleEffect(false);
        } else {
            super.handleEntityEvent(id);
        }
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)GaiaSounds.ANT_HILL_DEATH.get();
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        return false;
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public int getMaxHeadXRot() {
        return 180;
    }

    public int getMaxHeadYRot() {
        return 180;
    }

    public void push(Entity entity) {
    }

    public float getPickRadius() {
        return 0.0f;
    }

    public static boolean checkAntHillSpawnRules(EntityType<? extends AgeableMob> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return AntHill.checkDaysPassed(levelAccessor) && AntHill.checkPropSpawnRules(entityType, levelAccessor, spawnType, pos, random);
    }
}

