/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.prop;

import gaia.config.GaiaConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPropEntity
extends AgeableMob {
    protected AbstractPropEntity(EntityType<? extends AgeableMob> type, Level level) {
        super(type, level);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.isPassenger()) {
            this.stopRiding();
        }
    }

    public void finalizeAttributes() {
    }

    public static boolean checkAnyLightMonsterSpawnRules(EntityType<? extends AgeableMob> entityType, LevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return levelAccessor.getDifficulty() != Difficulty.PEACEFUL && AbstractPropEntity.checkMobSpawnRules(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public static boolean checkPropSpawnRules(EntityType<? extends AgeableMob> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return AbstractPropEntity.isDarkEnoughToSpawn(levelAccessor, pos, random) && AbstractPropEntity.checkAnyLightMonsterSpawnRules(entityType, (LevelAccessor)levelAccessor, spawnType, pos, random);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor levelAccessor, BlockPos pos, RandomSource random) {
        if (levelAccessor.getBrightness(LightLayer.SKY, pos) > random.nextInt(32)) {
            return false;
        }
        if (levelAccessor.getBrightness(LightLayer.BLOCK, pos) > 0) {
            return false;
        }
        int i = levelAccessor.getLevel().isThundering() ? levelAccessor.getMaxLocalRawBrightness(pos, 10) : levelAccessor.getMaxLocalRawBrightness(pos);
        return i <= random.nextInt(8);
    }

    public static boolean checkDayPropSpawnRules(EntityType<? extends AgeableMob> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return AbstractPropEntity.checkDaylight(levelAccessor, pos) && AbstractPropEntity.checkAnyLightMonsterSpawnRules(entityType, (LevelAccessor)levelAccessor, spawnType, pos, random);
    }

    protected static boolean checkDaylight(ServerLevelAccessor levelAccessor, BlockPos pos) {
        return levelAccessor.canSeeSky(pos) && levelAccessor.getBrightness(LightLayer.BLOCK, pos) == 0;
    }

    protected static boolean checkAboveSeaLevel(ServerLevelAccessor levelAccessor, BlockPos pos) {
        return AbstractPropEntity.checkAboveY(pos, levelAccessor.getSeaLevel());
    }

    protected static boolean checkAboveY(BlockPos pos, int yLevel) {
        return (Boolean)GaiaConfig.COMMON.disableYRestriction.get() != false || pos.getY() > yLevel;
    }

    protected static boolean checkBelowSeaLevel(ServerLevelAccessor levelAccessor, BlockPos pos) {
        return AbstractPropEntity.checkBelowY(pos, levelAccessor.getSeaLevel());
    }

    protected static boolean checkBelowY(BlockPos pos, int yLevel) {
        return (Boolean)GaiaConfig.COMMON.disableYRestriction.get() != false || pos.getY() < yLevel;
    }

    protected static boolean checkTagBlocks(ServerLevelAccessor levelAccessor, BlockPos pos, TagKey<Block> blockTag) {
        return levelAccessor.getBlockState(pos.below()).is(blockTag);
    }

    protected static boolean checkDaysPassed(ServerLevelAccessor levelAccessor) {
        if (((Boolean)GaiaConfig.COMMON.spawnDaysPassed.get()).booleanValue()) {
            return (int)(levelAccessor.dayTime() / 24000L) >= (Integer)GaiaConfig.COMMON.spawnDaysSet.get();
        }
        return true;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mob) {
        return null;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        this.finalizeAttributes();
        return super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, data);
    }
}

