/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.projectile;

import gaia.registry.GaiaRegistry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GaiaSmallFireball
extends SmallFireball {
    public GaiaSmallFireball(EntityType<? extends SmallFireball> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public GaiaSmallFireball(Level p_37375_, LivingEntity p_37376_, Vec3 p_347501_) {
        super(p_37375_, p_37376_, p_347501_);
    }

    public GaiaSmallFireball(Level p_37367_, double p_37368_, double p_37369_, double p_37370_, Vec3 p_347543_) {
        super(p_37367_, p_37368_, p_37369_, p_37370_, p_347543_);
    }

    public EntityType<?> getType() {
        return GaiaRegistry.SMALL_FIREBALL.get();
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
    }

    protected void onHitEntity(EntityHitResult entityResult) {
        Entity entity;
        if (!this.level().isClientSide && !(entity = entityResult.getEntity()).fireImmune()) {
            Level level;
            Entity entity1 = this.getOwner();
            int i = entity.getRemainingFireTicks();
            entity.setRemainingFireTicks(80);
            DamageSource damagesource = this.damageSources().fireball((Fireball)this, entity1);
            boolean flag = entity.hurt(damagesource, 4.0f);
            if (!flag) {
                entity.setRemainingFireTicks(i);
            } else if (entity1 instanceof LivingEntity && (level = this.level()) instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)entity1, (DamageSource)damagesource);
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }
}

